<?php
if ( have_posts() ):
  while ( have_posts() ): the_post();

$custom_css = get_field( 'custom_css' );
$head_html = get_field( 'custom_head' );
$body_html = get_field( 'custom_body' );
$footer_html = get_field( 'custom_footer' );
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo get_the_title(); ?></title>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script> 
<?php if ($head_html) echo $head_html; ?>
<link rel="stylesheet" href="https://www.dazzyclinic.jp/wp-content/themes/dazzyclinic/lp-cnts/lp-style.css">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
<?php
$custom_css = get_field( 'custom_css' );
if ( $custom_css ) {
  echo "<style>{$custom_css}</style>";
}
?>
</head>
<body>
<div class="lp-container">
  <main><?php echo get_field( 'custom_body' ); ?></main>

  <footer>
    <?php
    $footer_content = get_field( 'custom_footer' );
    if ( !empty( $footer_content ) ) {
      echo $footer_content;
    }
    ?>
    <p class="copyright">© <?php echo date('Y'); ?> 美容皮膚科 DAZZY CLINIC</p>
  </footer>
</div>
<script>
$('.js_tit').on('click', function () {
  /*クリックでコンテンツを開閉*/
  $(this).next().slideToggle(200);
  /*矢印の向きを変更*/
  $(this).toggleClass('open', 200);
});
</script>
</body>
</html>
<?php
endwhile;
endif;
?>