<?php
/*
Template Name: GLP-1
*/
?>
<?php get_header();?>

<!--background------------------->
<section class="bg_daisy"></section>
<?php custom_breadcrumb(); ?>

<!--contents------------------->
<div class="cnts"> 
  
  <!--GLP-1------------------->
  <section class="page_cnts">
    <h2>GLP-1<span>マンジャロダイエットとは</span></h2>
  </section>
  
  <!--nayami------------------->
  <section class="page_cnts nayami nayami_bg">
    <h2>1⽇10秒のがんばらない痩活</h2>
    <p class="point_top">自宅で</p>
    <div class="point3">
      <p>診療</p>
      <span>×</span>
      <p>処方</p>
      <span>×</span>
      <p>治療</p>
    </div>
    <p class="point_btm dot"><span>すべて</span>できます！</p>
  </section>
  
  <!--arrow------------------->
  <div class="page_arrow"> 
    
    <!--説明------------------->
    <section class="page_about">
      <h3>そもそもGLP-1って何？</h3>
      <p>GLP-1は、2型糖尿病治療薬として使われているホルモン製薬で、食欲抑制や血糖コントロールを助ける作用があるとされています。<br>近年、医師の判断により、生活習慣の見直しと組み合わせて体重管理を目的に使われるケースもあります。<br>※本剤は肥満症治療薬としては国内未承認です。</p>
      <div class="sayou">
        <p class="center">GLP-1の<br>
          働き</p>
        <p class="b_left">⾷欲を<br>
          抑制</p>
        <?php /*<p class="t_right">基礎代謝を<br>
          ⾼める</p>*/?>
        <p class="b_right">⾎糖値の<br>
          コントロール</p>
        <?php /*<p class="b_right">体重増加を<br>
          抑制</p>*/?>
      </div>
    </section>
    
    <!--説明------------------->
    <section class="page_about">
      <h3>GLP-1って安全なの？</h3>
      <p>当クリニックでは、厚⽣労働省により2型糖尿病の治療薬として認可されている、イーライリリー社のマンジャロ2.5mgと5mgを採用しています。(ただし、肥満治療薬としては承認されていませんので、⾃費診療になります。) 医師の適切な診察と注射指導を受け、その後の経過を⾒ていくことで、安全に継続していくことが可能です。</p>
      <h4>認可機関</h4>
      <div class="double">
        <ul>
          <li>アメリカ<br>
            ⾷品医薬品局</li>
          <li>欧州連合(EU)<br>
            加盟27カ国</li>
          <li>韓国<br>
            ⾷品医薬品安全処</li>
        </ul>
      </div>
      <h4>「マンジャロ」について</h4>
      <table>
        <tbody>
          <tr>
            <th>未承認医薬品等</th>
            <td>マンジャロは、2型糖尿病の治療薬として厚生労働省に承認されています。肥満治療目的での処方は国内で承認されていません。</td>
          </tr>
          <!--<tr>
            <th>入手経路等</th>
            <td>当院で使用しているサクセンダはノボノルディスクファーマ社で製造されたものを当院で個人輸入しています。</td>
          </tr>-->
          <tr>
            <th>国内の承認医薬品等の有無</th>
            <td>国内ではマンジャロと同成分のゼップバウンド、またサノレックス、ウゴービ等が肥満症の治療薬として承認されています。</td>
          </tr>
          <tr>
            <th>諸外国における安全性等に係る情報</th>
            <td>同一成分の注射製剤が日本の厚生労働省とアメリカ食品医薬品局（FDA）で肥満症治療薬として承認されています。</td>
          </tr>
        </tbody>
      </table>
    </section>
    
    <!--GLP-1説明------------------->
    <section class="page_about">
      <h3>なぜ痩せるの？</h3>
      <p>GLP-1は、⾎糖値を上げないようにする働きがあることに加え、胃の中の食物をゆっくりと消化させることで満腹感が得られやすく、⾷欲を抑制することにつながります。<br>
        そのため、ダイエットに有効であり、痩せやすい体質を⽬指したい方に適していると⾔えます。</p>
    </section>
    
    <!--副作用・リスク------------------->
    <section class="page_about last">
      <h3>副作用・リスク</h3>
      <p>GLP-1の副作用には以下のようなものがあります。</p>
      <p>悪心、嘔吐、便秘、下痢、胃酸過多などの胃腸障害。その他、脱力感、眩暈、腹痛　等悪心・嘔吐の症状に関しては初期段階で出やすい症状ですが徐々に改善傾向となります。</p>
      <table>
        <tbody>
          <tr>
            <th>禁忌事項</th>
            <td>GLP-1製剤に対し過敏症の既往のある方<br>
              妊娠中、授乳中、または妊娠の可能性のある方<br>
              腹水や浮腫がある方<br>
              透析療法を受けている方</td>
          </tr>
          <tr>
            <th>適応注意</th>
            <td>膵臓に異常のある方<br>
              がんの治療中、治療直後<br>
              心機能、腎機能、肝機能が低下している方<br>
              自己免疫疾患のある方</td>
          </tr>
        </tbody>
      </table>
    </section>
  </div>
  
  <!--nayami------------------->
  <section class="page_arrow_btm">
    <div class="inner">
      <h2>だから、こんな方におすすめ！</h2>
      <ul>
        <?php
        $free_item = SCF::get( 'glp1_osusume', 170 );
        foreach ( $free_item as $fields ) {
          ?>
        <li><span><?php echo $fields['glp1_osusume_li']; ?></span></li>
        <?php  } ?>
      </ul>
    </div>
  </section>
  
  <!--page_howto------------------->
  <section class="page_howto">
    <h2>How To<span>施術の流れ</span></h2>
    <?php $free_item = SCF::get( 'page_howto', 170 ); foreach ( $free_item as $fields ) { ?>
    <dl>
      <dt><?php echo wp_get_attachment_image($fields['page_howto_img'], 'large');?></dt>
      <dd>
        <p class="step"><?php echo $fields['page_howto_step']; ?></p>
        <?php if($fields['page_howto_time']):?>
        <p class="time"><?php echo wp_kses_post( $fields['page_howto_time'] ); ?></p>
        <?php endif;?>
        <p class="tit"><?php echo $fields['page_howto_tit']; ?></p>
        <?php echo nl2br( $fields['page_howto_txt'] ); ?>
    </dl>
    <?php } ?>
  </section>
  
  <!--support------------------->
  <section class="page_support">
    <h2>Support<span>当クリニックだけの安⼼サポート</span></h2>
    <?php $free_item = SCF::get( 'support', 170 ); foreach ( $free_item as $fields ) { ?>
    <dl>
      <dt><?php echo wp_get_attachment_image($fields['support_img'], 'large');?></dt>
      <dd>
        <p class="tit"><span class="step"><?php echo $fields['support_no']; ?></span><?php echo $fields['support_tit']; ?></p>
        <?php echo nl2br( $fields['support_txt'] ); ?>
    </dl>
    <?php } ?>
  </section>
  
  <!--price------------------->
  <section class="page_price">
    <h2>Price<span>料金のご案内</span></h2>
    <h3>マンジャロダイエット</h3>
    <?php echo do_shortcode('[table id=6 /]'); ?>
    <p class="zeikomi" style="margin-bottom: 4em;">料金はすべて税込です</p>
  </section>
  
  <!--payment------------------->
  <section class="page_cnts">
    <?/*<h2>Payment<span>お支払い方法について</span></h2>
    <p><?php echo nl2br ( $fields = scf::get('pay_plan', 170 )); ?></p>
    <div class="pay_price_box">
      <dl>
        <dt><?php echo $fields = scf::get('pay_course', 170 ); ?></dt>
        <dd><?php echo $fields = scf::get('pay_price', 170 ); ?>(税込)</dd>
      </dl>
      <p><?php echo nl2br ( $fields = scf::get('pay_txt', 170 )); ?></p>
    </div>
    <div class="payment_box">
      <p class="top">
        <?php $myfield = scf::get_option_meta( 'theme-options', 'payment' ); echo nl2br( $myfield ); ?>
      </p>
      <span>クレジットカード</span>
      <ul class="icon">
        <?php $free_item = SCF::get_option_meta( 'theme-options', 'credit_icon' ); foreach ( $free_item as $fields ) { ?>
        <li><?php echo wp_get_attachment_image($fields['credit_icon_li'], 'large');?></li>
        <?php } ?>
      </ul>
      <p>
        <?php $myfield = scf::get_option_meta( 'theme-options', 'credit_txt' ); echo nl2br( $myfield ); ?>
      </p>
      <!----> 
      <span>QR決済</span>
      <ul class="icon">
        <?php $free_item = SCF::get_option_meta( 'theme-options', 'qr_icon' ); foreach ( $free_item as $fields ) { ?>
        <li><?php echo wp_get_attachment_image($fields['qr_icon_li'], 'large');?></li>
        <?php } ?>
      </ul>
      <p>
        <?php $myfield = scf::get_option_meta( 'theme-options', 'qr_txt' ); echo nl2br( $myfield ); ?>
      </p>
      <!--ohter-->
      <?php $free_item = SCF::get_option_meta( 'theme-options', 'pay_other' ); foreach ( $free_item as $fields ) { ?>
      <span><?php echo $fields['pay_other_li']; ?></span>
      <?php } ?>
      </ul>
    </div>*/?>
    <div class="counseling" style="padding-top:0;margin-top:0!important;">      
      <h4>無料カウンセリング受付中</h4>
      <p>お気軽にご相談ください</p>
      <div class="btn"><a href="https://reservation.medical-force.com/c/36ed8b598ac34986bdc23ac30e2021e7/reservations/new?menu_entrance_id=67326781-860c-402d-8969-2eef799b1791" target="_blank">オンライン診療はこちら</a></div>
      <!-- <div class="btn"><a href="https://rsv.dazzyclinic.jp/stores/glp1/" target="_blank">札幌院の予約はこちら</a></div>
		<div class="btn"><a href="https://reservation.medical-force.com/c/0a865e188155486b851fb31ae1722893/reservations/new?menu_entrance_id=0f27b37a-5d62-4696-a19b-cd0b10fad066" target="_blank">福岡院の予約はこちら</a></div> --> 
    </div>
  </section>
  
  <!--faq------------------->
  <section class="faq page_faq">
    <h2>FAQ<span>よくある質問</span></h2>
    <?php
    $free_item = SCF::get( 'page_faq', 170 );
    foreach ( $free_item as $fields ) {
      if ( $fields[ 'page_faq_q' ] !== "" ) {
        ?>
    <dl>
      <dt class="faq_tit js_tit">
        <p><?php echo $fields['page_faq_q']; ?></p>
      </dt>
      <dd class="faq_content">
        <p><?php echo nl2br($fields['page_faq_a']); ?></p>
      </dd>
    </dl>
    <?php } } ?>
    <div class="btn"><a href="https://www.dazzyclinic.jp/faq/">その他のよくある質問</a></div>
  </section>
  
  <!--/cnts--> 
</div>
<?php get_footer();?>
