<?php
/*
Template Name: 医療痩身
*/
?>
<?php get_header();?>

<!--background------------------->
<section class="bg_daisy"></section>
<?php custom_breadcrumb(); ?>

<!--contents------------------->
<div class="cnts"> 
  
  <!--about_clnic------------------->
  <section class="about_clinic">
    <h2>Diet<span>医療痩身</span></h2>
    <p class="diet_intro">ダイエットは、<br>
      <span>医療のチカラ</span>で成功させる時代</p>
    <p class="diet_intro"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/main_1080x600.webp" alt="ダイエットは、医療のチカラで成功させる時代"></p>
  </section>
  
  <!--about_clnic------------------->
  <section class="about_clinic">    
    <div class="skin52_bg">
      <h3>医療機器施術による代謝アップ<br class="SP">
        ×<br class="SP">
        オーダーメイド内服薬処方 </h3>
      <p>医療のチカラで理想の体型を叶える！<br>
        従来のダイエットでは難しかった、脂肪細胞を小さくして<br>
        戻りにくくするアプローチが可能に。</p>
      <div class="box">
        <dl>
          <dt>施術可能院</dt>
          <dd>新宿院</dd>
        </dl>
      </div>
    </div>
  </section>
  
  <!--arrow------------------->
  <div class="page_arrow"> 
    
    <!--説明------------------->
    <section class="page_about skin52">
      <h3>こんなお悩みありませんか？</h3>
      <ul class="check">
        <li>パーソナルジムに通ったけど辞めたらリバウンドした</li>
        <li>エステに通ったけど体重が変わらなかった</li>
        <li>過度な食事制限や断食で太りやすくなってしまった</li>
        <li>代謝が落ちてきて痩せにくくなった</li>
        <li>何をしても痩せられない</li>
      </ul>
    </section>
    
    <!--/arrow-------------------> 
  </div>
  
  <!--nayami------------------->
  
  <section class="page_arrow_btm diet_3point">
    <h3>DAZZY CLINICの医療ダイエット</h3>
    <ul>
      <li><a href="#stretchmark"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/3point_1.webp" alt="GLP-1注射">
        <p>GLP-1注射</p>
        </a></li>
      <li><a href="#kizuato"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/3point_2.webp" alt="オーダーメイド内服薬">
        <p>オーダーメイド内服薬</p>
        </a></li>
      <li><a href="#hakuhan"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/3point_3.webp" alt="EXCARE PRO Ⅲ">
        <p>EXCARE PRO Ⅲ</p>
        </a></li>
    </ul>
  </section>
  
  <!--case------------------->
  <section class="page_cnts">
    <h2>Why<span>そもそもどうして太るの？</span></h2>
    
    <!---->
    <div class="skin52_case" id="stretchmark">
      <div class="inner">        
        <p><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/why_1.webp" alt="そもそもどうして太るの？"></p>
        <p>私たち人間は細胞でできています。そのため、太る痩せるに関しては<span>脂肪細胞</span>という細胞が関わっています。この脂肪細胞が増えることで太るというイメージを持っている方が多いのですが、本来、脂肪細胞は20歳までで数が決まるため、そこから数はほぼ変動しません。<span>脂肪細胞の大きさによって人は太ります</span>。<br>
          リバウンドしにくい痩せた身体を作るには、<span>脂肪細胞を小さくして戻りにくくすることが重要です。</span></p>
      </div>
    </div>
    
    <!---->
    <div class="skin52_case" id="hakuhan">
      <div class="inner">
        <h3>GLP-1注射</h3>
        <p>当院のGLP-1ダイエットは、<span>GLP-1ホルモン</span>を週に一回投与するだけで食欲を抑えることが可能なため、ダイエットに時間を作れない方にも非常にお勧めのダイエット法です。<br>
          適切な食事制限や有酸素運動は平行して行うことで、より痩せやすい体質を持続することが可能です。</p>
        
        <!---->
        <div class="box pink">
          <h4>GLP-1ホルモンって？</h4>
          <p>GLP-1ホルモンは＜痩せホルモン＞と呼ばれるものです。元々私たちの体の中にあるホルモンで、一定の役割をこなしています。<br>
            しかし、GLP-1ホルモンは体形によって濃度が変化するため、体が太ることでホルモンが薄まり効きが弱くなると、<span>「食べても食べてもお腹いっぱいにならない」「つい食べ過ぎてしまう」</span>というダイエットを妨げる現象が起きてしまうのです </p>
          <div class="flex">
            <dl>
              <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/why_2.webp" alt="オゼンピック"></dt>
              <dd>オゼンピック</dd>
            </dl>
          </div>
          <p><span>GLP-1ダイエット</span>は、GLP-1ホルモンを一時的に体に取り込み、痩せることで、血糖値を安定させて、さらに体内のホルモン濃度を太りにくい状態に変えていくことができるダイエットです。</p>
        </div>
        
        <!---->
        <div class="box pink">
          <h4>こんな方におすすめ</h4>
          <ul class="check">
            <li>食事管理がしづらい方</li>
            <li>トレーニングをする時間がない方</li>
            <li>仕事が忙しくて夕食が深夜になりがちな方</li>
          </ul>
        </div>
        
        <!---->
        <div class="btn"><a href="https://www.dazzyclinic.jp/glp1/">詳しくはこちら</a></div>
      </div>
    </div>
    
    <!---->
    <div class="skin52_case" id="hakuhan">
      <div class="inner">
        <h3>オーダーメイド内服薬</h3>
        <p>豊富なラインナップから、お体に合わせて内服薬を処方いたします。<br>
          お悩みや傾向に合わせてお選び致しますので、カウンセリングでご相談ください。 </p>
        
        <!---->
        <div class="box pink">
          <h4>内服薬のラインナップ</h4>
          <div class="flex">
            <dl>
              <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/medicine_1.webp" alt="SGLT2阻害薬（カナグル）"></dt>
              <dd>SGLT2阻害薬（カナグル）</dd>
              <dd class="white">1日1回 朝食前
                <p>効果</p>
                ・糖分の吸収を阻害する<br>
                ・糖分を80～100gほど尿から排出させる</dd>
            </dl>
            <dl>
              <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/medicine_2.webp" alt="メトホルミン"></dt>
              <dd>メトホルミン</dd>
              <dd class="white">1日2回 食前
                <p>効果</p>
                ・腸内での糖の吸収を阻害する<br>
                ・脂肪燃焼効果</dd>
            </dl>
            <dl>
              <dt><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/medicine_3.webp" alt="ゼニカル"></dt>
              <dd>ゼニカル</dd>
              <dd class="white">油物の食事をとる前
                <p>効果</p>
                ・油分の吸収を阻害し、便中から排出させる</dd>
            </dl>
          </div>
        </div>
        
        <!---->
        <div class="box pink">
          <h4>こんな方におすすめ</h4>
          <ul class="check">
            <li>身体がむくみがち</li>
            <li>便秘に悩んでいる</li>
            <li>油分の多い食事が好き</li>
          </ul>
        </div>
      </div>
    </div>
    
    <!---->
    <div class="skin52_case" id="hakuhan">
      <div class="inner">
        <h3>EXCARE PRO Ⅲ</h3>
        <p>ダイエットに大きく影響してくる基礎代謝は筋肉量によって変化しています。筋肉量が増えれば増えるほど基礎代謝はアップ。反対に筋肉量が減ると基礎代謝もダウンしてしまいます。<br>
          運動し続けないと無くなってしまう<span>アウターマッスル</span>と、一度つけると無くなりづらい<span>インナーマッスル</span>。筋肉には大きく2種類あります。<br>
          EXCARE PRO Ⅲは、脂肪をエネルギー源として作動してくれる<span>インナーマッスル</span>を鍛えるマシンです。</p>
        
        <!---->
        <div class="box pink">
          <h4>EXCARE PRO Ⅲって？</h4>
          <p><img src="https://www.dazzyclinic.jp/wp-content/uploads/2023/01/why_3.webp" alt="EXCARE PRO Ⅲ"></p>
          <p>特許取得の「ダブルインパクト波形」によりインナーマッスルをトレーニングできるマシンです。<br>
            従来の高周波複合波型EMS機器をさらにグレードアップさせた最新機種で、複合高周波により深くエネルギーが入ります。筋力を維持し基礎代謝を上げるため、消費効果が高くリバウンドしにくい体作りを実現します。更に有酸素運動と同じ効果を出すことによって運動していることと同じ様な効果を得られます。</p>
        </div>
        
        <!---->
        <div class="box pink">
          <h4>こんな方におすすめ</h4>
          <ul class="check">
            <li>筋トレ等運動が苦手</li>
            <li>基礎代謝が低い</li>
            <li>筋肉がつきずらい</li>
          </ul>
        </div>
      </div>
    </div>
  </section>
  
  <!--support------------------->
  <section class="page_support">
    <h2>About<span>DAZZY CLINICダイエットの通い方</span></h2>
    <?php $free_item = SCF::get( 'support', 1939 ); foreach ( $free_item as $fields ) { ?>
    <dl>
      <dt><?php echo wp_get_attachment_image($fields['support_img'], 'large');?></dt>
      <dd>
        <p class="tit"><span class="step"><?php echo $fields['support_no']; ?></span><?php echo $fields['support_tit']; ?></p>
        <?php echo nl2br( $fields['support_txt'] ); ?>
    </dl>
    <?php } ?>
  </section>
  
  <!--case------------------->
  <section class="page_cnts diet_course">
    <h2>Course<span>DAZZY CLINICダイエットの通い方</span></h2>
    <div>
      <h3>2ヶ月減量コース</h3>
      <p>短期間でサクッと減量したい方へ</p>
      <dl>
        <dt>GLP-1</dt>
        <dd>週に1回 8回分 減量感を得たい方へ</dd>
        <dt>EXCARE PROⅢ</dt>
        <dd>代謝の維持＋向上とリバウンド防止</dd>
        <dt>内服薬2種類</dt>
        <dd>医師と相談しながら選べる</dd>
      </dl>
    </div>
    <div>
      <h3>3ヶ月習慣化コース</h3>
      <p>長期的に見て習慣化してしたい方へ</p>
      <dl>
        <dt>GLP-1</dt>
        <dd>週に1回 12回分 週間化させて瘦せ体質に</dd>
        <dt>EXCARE PROⅢ</dt>
        <dd>代謝の維持＋向上とリバウンド防止</dd>
        <dt>内服薬3種類</dt>
        <dd>医師と相談しながら選べる</dd>
      </dl>
    </div>
  </section>
  
  <!--payment------------------->
  <section class="page_cnts">
    <h2>Payment<span>お支払い方法</span></h2>
    <div class="payment_box" style="margin-top: 2em;">
      <p class="top">お⽀払いは、「現金一括払い」「クレジットカード」「QRコード決済」「電子マネー」「交通系IC各種」のいずれかよりお選びいただけます。</p>
      <span>現金一括払い</span> 
      <!----> 
      <span>医療ローン</span> 
      <!----> 
      <span>クレジットカード</span>
      <ul class="icon">
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/visa.webp" alt="VISA"></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/mastercard.webp" alt="MasterCard"></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/jcb.webp" alt="JCB"></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/amex.webp" alt="AMERICAN EXPRESS"></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/dinersclub.webp" alt="Diners Club"></li>
      </ul>
      <p>VISA / MasterCard / JCB / AMERICAN EXPRESS / Diners Club</p>
      <!----> 
      <span>QR決済</span>
      <ul class="icon">
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/dbarai.webp" alt=""></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/rpay.webp" alt=""></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/yutyo.webp" alt=""></li>
      </ul>
      <p>各種QR決済</p>
      <!--ohter--> 
      <span>電子マネー</span>
      <ul class="icon">
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/id.webp" alt=""></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/waon.webp" alt=""></li>
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/nanaco.webp" alt=""></li>
      </ul>
      <p>各種電子マネー</p>
      <span>交通系IC各種</span>
      <ul class="icon icon_img">
        <li><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/06/ic.webp" alt="交通系IC各種"></li>
      </ul>
      <p>各種交通系IC各種</p>
    </div>
    <div class="counseling">
      <h4>無料カウンセリングはこちら</h4>
      <p>ご予約日が近づきますと、総合受付からお電話をいたします。<br>
        その際に○○○希望とお伝えいただくとスムーズです。</p>
      <div class="btn"><a href="https://rsv.dazzyclinic.jp/stores/artmake/?stcd=osaka" target="_blank">ご予約フォームへ進む</a></div>
    </div>
  </section>
  
  <!--faq------------------->
  <section class="faq page_faq">
    <h2>FAQ<span>よくある質問</span></h2>
    <?php
    $free_item = SCF::get( 'page_faq', 1939 );
    foreach ( $free_item as $fields ) {
      if ( $fields[ 'page_faq_q' ] !== "" ) {
        ?>
    <dl>
      <dt class="faq_tit js_tit">
        <p><?php echo $fields['page_faq_q']; ?></p>
      </dt>
      <dd class="faq_content">
        <p><?php echo nl2br($fields['page_faq_a']); ?></p>
      </dd>
    </dl>
    <?php } } ?>
    <div class="btn"><a href="https://www.dazzyclinic.jp/faq/">その他のよくある質問</a></div>
  </section>
  
  <!--/cnts--> 
</div>
<?php get_footer();?>
