<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>
<?php
global $page, $paged;
if ( is_front_page() ): //トップページ
  echo '';
bloginfo( 'name' );
elseif ( is_home() ): //ブログページ（ブログサイトの場合はトップページ）
  wp_title( '｜', true, 'right' );
bloginfo( 'name' );
elseif ( is_page() ): //固定ページ
  wp_title( '｜', true, 'right' );
bloginfo( 'name' );
elseif ( is_single() ): //投稿ページ
  wp_title( '｜', true, 'right' );
bloginfo( 'name' );
elseif ( is_category() ): //カテゴリーページ
  single_term_title();
echo '｜省略タイトル';
elseif ( is_tag() ): //タグページ
  single_term_title();
echo '｜省略タイトル';
elseif ( is_archive() ): //アーカイブページ
  wp_title( '' );
echo '｜省略タイトル';
elseif ( is_search() ): //検索結果ページ
  wp_title( '' );
echo '｜省略タイトル';
elseif ( is_404() ): //404ページ
  echo '404｜';
bloginfo( 'name' );
endif;
if ( $paged >= 2 || $page >= 2 ): //２ページ目以降の場合
  echo '｜' . sprintf( '%sページ',
    max( $paged, $page ) );
endif;
?>
</title>
<link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>" type="text/css">
<style>
@import url('https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,400;0,700;1,400&display=swap');
</style>
<!--style_old-->
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/style_2205.css">
<?php if ( is_page('pill') ): ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/pill.css">
<?php endif; ?>
<?php if ( is_page('glp1') ): ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/glp1.css?1">
<?php endif; ?>
<?php if ( is_page('artmake') ): ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/artmake.css">
<?php endif; ?>
<?php if ( is_page('cliniclist') ): ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/clinic.css?333">
<?php endif; ?>
<?php if ( is_singular('cdetail') ): ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/clinic.css?2401">
<?php endif; ?>
<?php if ( is_page('test') ): ?>
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/test.css">
<?php endif; ?>
<!--style_new-->
<link href="<?php echo get_template_directory_uri(); ?>/css/style_re.css?250" rel="stylesheet" type="text/css">
<?php if ( !is_home() && !is_front_page() ) : ?>
<link href="<?php echo get_template_directory_uri(); ?>/css/page.css?2404" rel="stylesheet" type="text/css">
<?php endif; ?>
<!--スライダー--> 
<script src="<?php echo get_template_directory_uri(); ?>/slick/slick.min.js" type="text/javascript"></script>
<link href="<?php echo get_template_directory_uri(); ?>/slick/slick-theme.css" rel="stylesheet">
<link href="<?php echo get_template_directory_uri(); ?>/slick/slick.css" rel="stylesheet">

<!-- パラメータ引き継ぎ設定スクリプト　--> 
<script>
var prm;
function retrieveGETqs() {
  var query = window.location.search.substring(1);
  return query;
  /* 引数がない時は処理しない */
  if (!query) return false;
}
$(function () {
  jQuery('.url').click(function () {

    //リンク先を取得
    var target_url = $(this).attr("href");

    //パラメータを取得
    var str = retrieveGETqs();
    prm = decodeURIComponent(str);

    if (prm) {
      //target_urlに'？'を含む場合
      if (target_url.indexOf('?') != -1) {
        //追加パラメータの先頭文字列を'&'に置換
        $('a.url').attr('href', target_url + '&' + prm);
      } else {
        $('a.url').attr('href', target_url + '?' + prm);
      }
    }
  })
})
; //# sourceURL=foobar.js
// JavaScript Document
</script> 
<!-- パラメータ引き継ぎ設定スクリプト-->

<?php wp_head(); ?>

<!-- Google Tag Manager --> 
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-WRR44Z9');</script> 
<!-- End Google Tag Manager -->
</head>

<body <?php body_class(); ?>>
<!-- Google Tag Manager (noscript) -->
<noscript>
<iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WRR44Z9"
height="0" width="0" style="display:none;visibility:hidden"></iframe>
</noscript>
<!-- End Google Tag Manager (noscript) --> 

<!---->
<header>
  <div class="hd_left">
    <h1><a href="https://www.dazzyclinic.jp/">
      <?php
      $myfield = scf::get_option_meta( 'theme-options', 'logo' );
      echo wp_get_attachment_image( $myfield, 'full' );
      ?>
      </a></h1>
    <?php if(!wp_is_mobile()): ?>
    <nav>
      <ul id="pc_menu">
        <li class="menu_list"> <a href="https://www.dazzyclinic.jp/about/">ABOUT<span>クリニックについて</span></a> </li>
        
        <!---->
        <li class="menu_list"> <a href="https://dazzyclinic.jp/artmake/">ART MAKE<span>医療アートメイク</span></a>
          <div class="menu_contents">
            <ul>
              <?php echo (''); wp_nav_menu( array( 'menu' => '医療アートメイク', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
            </ul>
          </div>
        </li>
        
        <!---->
        <li class="menu_list"> <a href="https://dazzyclinic.jp/skin/">SKIN<span>美容皮膚科</span></a>
          <div class="menu_contents">
            <ul>
              <?php echo (''); wp_nav_menu( array( 'menu' => '美容皮膚科', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
            </ul>
          </div>
        </li>
        
        <!---->
        <li class="menu_list"> <a href="https://www.dazzyclinic.jp#othermenu">MENU<span>診療メニュー</span></a>
          <div class="menu_contents">
            <ul>
              <?php echo (''); wp_nav_menu( array( 'menu' => '診療メニュー', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
            </ul>
          </div>
        </li>
        
        <!---->
        <li class="menu_list"> <a href="https://www.dazzyclinic.jp/cliniclist/">CLINIC<span>クリニック一覧</span></a>
          <div class="menu_contents">
            <ul>
              <?php echo (''); wp_nav_menu( array( 'menu' => 'クリニック一覧', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
            </ul>
          </div>
        </li>
        
        <!---->
      </ul>
    </nav>
    <?php endif; ?>
  </div>
  <div class="hd_right"> 
    
    <!--予約-->
    <div class="hd_rsv">
      <label for="label3"><span>ご予約はこちら</span></label>
      <input type="checkbox" id="label3"/>
      <div class="hidden_show"> 
        <!--非表示ここから-->
        <div class="hd_rsv_inner">
          <h4> 電話予約 </h4>
          <div class="hd_tell"><a href="tel:<?php $myfield = scf::get_option_meta('theme-options', 'tel_sogo'); echo $myfield; ?>"><span>総合受付ダイヤル</span> <img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/05/tel_s.png" alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50">
            <?php $myfield = scf::get_option_meta('theme-options', 'tel_sogo'); echo $myfield; ?>
            </a></div>
          <?/*<div class="hd_tell"><a href="tel:06-6786-8701"><span>心斎橋専用ダイヤル</span> <img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/05/tel_s.png" alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50"> 06-6786-8701 </a></div>*/?>
        </div>
        <div class="hd_rsv_inner">
          <h4> web予約 </h4>
          <ul>
            <li><a href="https://www.dazzyclinic.jp/reserve/#shinjuku" class="url">新宿本院</a></li>
            <li><a href="https://www.dazzyclinic.jp/reserve/#sapporo" class="url">札幌院</a></li>
            <?php /*<li><a href="https://www.dazzyclinic.jp/reserve/#shinsaibashi" class="url">心斎橋院</a></li>*/?>
            <li><a href="https://www.dazzyclinic.jp/reserve/#fukuoka" class="url">福岡院</a></li>
            <?php /*<li class="long"><a href="https://www.dazzyclinic.jp/reserve/#fukuoka_skin" class="url">福岡スキンケア専門院</a></li>*/?>
          </ul>
        </div>
        <!--ここまで--> 
      </div>
    </div>
    <?php
    /*
       <div class="hd_rsv">
         <label for="label2"><span class="PC">WEB予約はこちら</span><span class="SP">WEB<br>
           予約</span></label>
         <input type="checkbox" id="label2"/>
         <div class="hidden_show"> 
           <!--非表示ここから-->
           <ul>
             <li><a href="https://www.dazzyclinic.jp/reserve/#shinjuku" class="url">新宿本院</a></li>
             <li><a href="https://www.dazzyclinic.jp/reserve/#sapporo" class="url">札幌院</a></li>
             <li><a href="https://www.dazzyclinic.jp/reserve/#shinsaibashi" class="url">心斎橋院</a></li>
             <li><a href="https://www.dazzyclinic.jp/reserve/#fukuoka" class="url">福岡院</a></li>
             <li class="long"><a href="https://www.dazzyclinic.jp/reserve/#fukuoka_skin" class="url">福岡スキンケア専門院</a></li>
           </ul>
           <!--ここまで--> 
         </div>
       </div>
       <div class="hd_tell"><a href="tel:<?php $myfield = scf::get_option_meta('theme-options', 'tel_sogo'); echo $myfield; ?>"><span>総合受付ダイヤル</span><br class="SP">
         <img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/05/tel_s.png" alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50">
         <?php $myfield = scf::get_option_meta('theme-options', 'tel_sogo'); echo $myfield; ?>
         </a></div>*/
    ?>
  </div>
  <div class="nav_open"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/05/menu_w.png" alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50"><span>MENU</span></div>
</header>
<?php if(wp_is_mobile()): ?>
<nav id="sd-menu">
  <div class="nav_head">
    <h1>
      <?php
      $myfield = scf::get_option_meta( 'theme-options', 'logo' );
      echo wp_get_attachment_image( $myfield, 'full' );
      ?>
    </h1>
    <div class="nav_close"><img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/05/close_s.png" alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50"><span>CLOSE</span></div>
  </div>
  <?
  /*
   <div class="nav_rsv">
     <div class="nav_tel"> <a href="tel:<?php $myfield = scf::get_option_meta('theme-options', 'tel_sogo'); echo $myfield; ?>">
       <p>総合受付ダイヤル</p>
       <img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/05/tel_s.png" alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50"><span class="telno">
       <?php $myfield = scf::get_option_meta('theme-options', 'tel_sogo'); echo $myfield; ?>
       </span><span>電話受付
       <?php $myfield = scf::get_option_meta('theme-options', 'tel_sogo_time'); echo $myfield; ?>
       </span></a> <a href="tel:06-6786-8701">
       <p style="margin-top: 1em;">心斎橋院専用</p>
       <img src="https://www.dazzyclinic.jp/wp-content/uploads/2022/05/tel_s.png" alt="美容皮膚科 DAZZY CLINIC（デイジークリニック）｜東京渋谷・札幌・福岡・大阪・新宿" width="50" height="50"><span class="telno"> 06-6786-8701 </span><span>電話受付
       <?php $myfield = scf::get_option_meta('theme-options', 'tel_sogo_time'); echo $myfield; ?>
       </span></a> </div>
     <div class="nav_web"> <a href="https://www.dazzyclinic.jp/reserve/">WEB予約はこちら<span>24時間お申込み可能</span>
       <p>予約メニューを選ぶ</p>
       </a></div>
   </div>*/
  ?>
  <ul class="nav_menu">
    <li>
      <p class="nav_tit js_tit">医療アートメイク</p>
      <ul class="nav_content">
        <?php echo (''); wp_nav_menu( array( 'menu' => '医療アートメイク', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
      </ul>
    </li>
    <li>
      <p class="nav_tit js_tit">美容皮膚科</p>
      <ul class="nav_content">
        <?php echo (''); wp_nav_menu( array( 'menu' => '美容皮膚科', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
      </ul>
    </li>
    <li>
      <p class="nav_tit js_tit">診療メニュー</p>
      <ul class="nav_content">
        <?php echo (''); wp_nav_menu( array( 'menu' => '診療メニュー', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
      </ul>
    </li>
    <li>
      <p class="nav_tit js_tit">クリニック一覧</p>
      <ul class="nav_content">
        <?php echo (''); wp_nav_menu( array( 'menu' => 'クリニック一覧', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
      </ul>
    </li>
    <?php echo (''); wp_nav_menu( array( 'menu' => 'クリニックについて', 'items_wrap' => '%3$s', 'container' => false ) ); ?>
  </ul>
</nav>
<?php endif; ?>
