<?php
/**
 * Functions and definitions
 *
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */
// 記事のpタグを出力しない
remove_filter( 'the_content', 'wpautop' );
// 抜粋のpタグを出力しない
remove_filter( 'the_excerpt', 'wpautop' );
// This theme requires WordPress 5.3 or later.
if ( version_compare( $GLOBALS[ 'wp_version' ], '5.3', '<' ) ) {
  require get_template_directory() . '/inc/back-compat.php';
}

// タクソノミーURL　Rewrite
add_rewrite_rule( 'cliniclist/([^/]+)/?$', 'index.php?cdetail=$matches[1]', 'top' );
// タクソノミーURL　ページ送りも設定
add_rewrite_rule( 'cliniclist/([^/]+)/page/([0-9]+)/?$', 'index.php?cdetail=$matches[1]&paged=$matches[2]', 'top' );

add_action( 'init', 'create_post_type' );

function create_post_type() {
  register_post_type( 'cdetail', [ // 投稿タイプ名の定義
    'labels' => [
      'name' => 'クリニック詳細', // 管理画面上で表示する投稿タイプ名
      'singular_name' => 'cdetail', // カスタム投稿の識別名
    ],
    'public' => true, // 投稿タイプをpublicにするか
    'has_archive' => false, // アーカイブ機能ON/OFF
    'menu_position' => 5, // 管理画面上での配置場所
    'show_in_rest' => true, // 5系から出てきた新エディタ「Gutenberg」を有効にする
    'rewrite' =>
    //↑rewriteの指定をする
    array( 'slug' => 'cliniclist', 'with_front' => 'false' ),
  ] );
  register_taxonomy_for_object_type( 'category', 'cdetail' );
  register_taxonomy_for_object_type( 'post_tag', 'cdetail' );
}

// パンくずリスト自動生成
if ( !function_exists( 'custom_breadcrumb' ) ) {
  function custom_breadcrumb() {
    // トップページでは何も出力しないように
    if ( is_front_page() ) return false;
    //そのページのWPオブジェクトを取得
    $wp_obj = get_queried_object();
    echo '<section class="breadcrumb">' . //id名などは任意で
    '<ol>' .
    '<li>' .
    '<a href="' . esc_url( home_url() ) . '"><span>DAZZYCLINIC</span></a>' .
    '</li>';
    if ( is_attachment() ) {
      /**
       * 添付ファイルページ ( $wp_obj : WP_Post )
       * ※ 添付ファイルページでは is_single() も true になるので先に分岐
       */
      $post_title = apply_filters( 'the_title', $wp_obj->post_title );
      echo '<li><span>' . esc_html( $post_title ) . '</span></li>';
    } elseif ( is_single() ) {
      /**
       * 投稿ページ ( $wp_obj : WP_Post )
       */
      $post_id = $wp_obj->ID;
      $post_type = $wp_obj->post_type;
      $post_title = apply_filters( 'the_title', $wp_obj->post_title );
      // カスタム投稿タイプかどうか
      if ( $post_type !== 'post' ) {
        $the_tax = "cdetail"; //そのサイトに合わせて投稿タイプごとに分岐させて明示的に指定してもよい
        // 投稿タイプに紐づいたタクソノミーを取得 (投稿フォーマットは除く)
        $tax_array = get_object_taxonomies( $post_type, 'names' );
        foreach ( $tax_array as $tax_name ) {
          if ( $tax_name !== 'post_format' ) {
            $the_tax = $tax_name;
            break;
          }
        }
        $post_type_link = esc_url( get_post_type_archive_link( $post_type ) );
        $post_type_label = esc_html( get_post_type_object( $post_type )->label );
        //カスタム投稿タイプ名の表示
        echo '<li>' .
        '<a href="https://www.dazzyclinic.jp/cliniclist/">' .
        '<span>クリニック一覧</span>' .
        '</a>' .
        '</li>';
      }
      elseif ( $post_type !== 'post' ) {
        $the_tax = "aaa"; //そのサイトに合わせて投稿タイプごとに分岐させて明示的に指定してもよい
        // 投稿タイプに紐づいたタクソノミーを取得 (投稿フォーマットは除く)
        $tax_array = get_object_taxonomies( $post_type, 'names' );
        foreach ( $tax_array as $tax_name ) {
          if ( $tax_name !== 'post_format' ) {
            $the_tax = $tax_name;
            break;
          }
        }
        $post_type_link = esc_url( get_post_type_archive_link( $post_type ) );
        $post_type_label = esc_html( get_post_type_object( $post_type )->label );
        //カスタム投稿タイプ名の表示
        echo '<li>' .
        '<a href="' . $post_type_link . '">' .
        '<span>' . $post_type_label . '</span>' .
        '</a>' .
        '</li>';
      }
      else {
        $the_tax = 'category'; //通常の投稿の場合、カテゴリーを表示
      }
      // 投稿に紐づくタームを全て取得
      $terms = get_the_terms( $post_id, $the_tax );
      // タクソノミーが紐づいていれば表示
      if ( $terms !== false ) {
        $child_terms = array(); // 子を持たないタームだけを集める配列
        $parents_list = array(); // 子を持つタームだけを集める配列
        //全タームの親IDを取得
        foreach ( $terms as $term ) {
          if ( $term->parent !== 0 ) {
            $parents_list[] = $term->parent;
          }
        }
        //親リストに含まれないタームのみ取得
        foreach ( $terms as $term ) {
          if ( !in_array( $term->term_id, $parents_list ) ) {
            $child_terms[] = $term;
          }
        }
        // 最下層のターム配列から一つだけ取得
        $term = $child_terms[ 0 ];
        if ( $term->parent !== 0 ) {
          // 親タームのIDリストを取得
          $parent_array = array_reverse( get_ancestors( $term->term_id, $the_tax ) );
          foreach ( $parent_array as $parent_id ) {
            $parent_term = get_term( $parent_id, $the_tax );
            $parent_link = esc_url( get_term_link( $parent_id, $the_tax ) );
            $parent_name = esc_html( $parent_term->name );
            echo '<li>' .
            '<a href="' . $parent_link . '">' .
            '<span>' . $parent_name . '</span>' .
            '</a>' .
            '</li>';
          }
        }
      }
      // 投稿自身の表示
      echo '<li><span>' . esc_html( strip_tags( $post_title ) ) . '</span></li>';
    } elseif ( is_page() || is_home() ) {
      /**
       * 固定ページ ( $wp_obj : WP_Post )
       */
      $page_id = $wp_obj->ID;
      $page_title = apply_filters( 'the_title', $wp_obj->post_title );
      // 親ページがあれば順番に表示
      if ( $wp_obj->post_parent !== 0 ) {
        $parent_array = array_reverse( get_post_ancestors( $page_id ) );
        foreach ( $parent_array as $parent_id ) {
          $parent_link = esc_url( get_permalink( $parent_id ) );
          $parent_name = esc_html( get_the_title( $parent_id ) );
          echo '<li>' .
          '<a href="' . $parent_link . '">' .
          '<span>' . $parent_name . '</span>' .
          '</a>' .
          '</li>';
        }
      }
      // 投稿自身の表示
      echo '<li><span>' . esc_html( strip_tags( $page_title ) ) . '</span></li>';
    } elseif ( is_post_type_archive() ) {
      /**
       * 投稿タイプアーカイブページ ( $wp_obj : WP_Post_Type )
       */
      echo '<li><span>' . esc_html( $wp_obj->label ) . '</span></li>';
    } elseif ( is_date() ) {
      /**
       * 日付アーカイブ ( $wp_obj : null )
       */
      $year = get_query_var( 'year' );
      $month = get_query_var( 'monthnum' );
      $day = get_query_var( 'day' );
      if ( $day !== 0 ) {
        //日別アーカイブ
        echo '<li>' .
        '<a href="' . esc_url( get_year_link( $year ) ) . '"><span>' . esc_html( $year ) . '年</span></a>' .
        '</li>' .
        '<li>' .
        '<a href="' . esc_url( get_month_link( $year, $month ) ) . '"><span>' . esc_html( $month ) . '月</span></a>' .
        '</li>' .
        '<li>' .
        '<span>' . esc_html( $day ) . '日</span>' .
        '</li>';
      } elseif ( $month !== 0 ) {
        //月別アーカイブ
        echo '<li>' .
        '<a href="' . esc_url( get_year_link( $year ) ) . '"><span>' . esc_html( $year ) . '年</span></a>' .
        '</li>' .
        '<li>' .
        '<span>' . esc_html( $month ) . '月</span>' .
        '</li>';
      } else {
        //年別アーカイブ
        echo '<li><span>' . esc_html( $year ) . '年</span></li>';
      }
    } elseif ( is_author() ) {
      /**
       * 投稿者アーカイブ ( $wp_obj : WP_User )
       */
      echo '<li><span>' . esc_html( $wp_obj->display_name ) . ' の執筆記事</span></li>';
    } elseif ( is_archive() ) {
      /**
       * タームアーカイブ ( $wp_obj : WP_Term )
       */
      $term_id = $wp_obj->term_id;
      $term_name = $wp_obj->name;
      $tax_name = $wp_obj->taxonomy;
      /* ここでタクソノミーに紐づくカスタム投稿タイプを出力しても良いでしょう。 */
      // 親ページがあれば順番に表示
      if ( $wp_obj->parent !== 0 ) {
        $parent_array = array_reverse( get_ancestors( $term_id, $tax_name ) );
        foreach ( $parent_array as $parent_id ) {
          $parent_term = get_term( $parent_id, $tax_name );
          $parent_link = esc_url( get_term_link( $parent_id, $tax_name ) );
          $parent_name = esc_html( $parent_term->name );
          echo '<li>' .
          '<a href="' . $parent_link . '">' .
          '<span>' . $parent_name . '</span>' .
          '</a>' .
          '</li>';
        }
      }
      // ターム自身の表示
      echo '<li>' .
      '<span>' . esc_html( $term_name ) . '</span>' .
      '</li>';
    } elseif ( is_search() ) {
      /**
       * 検索結果ページ
       */
      echo '<li><span>「' . esc_html( get_search_query() ) . '」で検索した結果</span></li>';

    } elseif ( is_404() ) {
      /**
       * 404ページ
       */
      echo '<li><span>お探しの記事は見つかりませんでした。</span></li>';
    } else {
      /**
       * その他のページ（無いと思うけど一応）
       */
      echo '<li><span>' . esc_html( get_the_title() ) . '</span></li>';
    }
    echo '</ol></section>'; // 冒頭に合わせた閉じタグ
  }
}

//共通SFC
/**
 * @param string $page_title ページのtitle属性値
 * @param string $menu_title 管理画面のメニューに表示するタイトル
 * @param string $capability メニューを操作できる権限（maange_options とか）
 * @param string $menu_slug オプションページのスラッグ。ユニークな値にすること。
 * @param string|null $icon_url メニューに表示するアイコンの URL
 * @param int $position メニューの位置
 */
SCF::add_options_page( 'サイト共通設定', '共通設定', 'manage_options', 'theme-options', 'dashicons-star-filled', 1 );

//固定ページからエディタ削除
function disable_visual_editor_in_page() {
  global $typenow;
  $post_id = $_GET[ 'post' ];
  if ( $typenow == 'page' ) {
    if ( in_array( $post_id, array( '1056', '1214' ), true ) ) {
      $hide_postdiv_css = '<style type="text/css">#postdiv, #postdivrich { display: none; }</style>';
      echo $hide_postdiv_css;
    }
  }
}
add_action( 'load-post.php', 'disable_visual_editor_in_page' );
add_action( 'load-post-new.php', 'disable_visual_editor_in_page' );


//wp-headから削除
function dequeue_plugins_style() {
  wp_dequeue_style( 'wp-block-library' );
  wp_dequeue_style( 'global-styles' );
}
add_action( 'wp_enqueue_scripts', 'dequeue_plugins_style', 9999 );
add_action( 'wp_enqueue_scripts', 'remove_my_global_styles' );

remove_action( 'wp_head', 'wp_generator' );
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );

//編集リンク削除
add_filter( 'edit_post_link', '__return_false' );