<?php

use Uncanny_Automator\Recipe;

/**
 * Class UOA_SHOWNOTICE
 */
class BRAVEPOP_ACTION {
	use Recipe\Actions;

	/**
	 * UOA_SHOWNOTICE constructor.
	 */
	public function __construct() {
		$this->setup_action();
	}

   protected function setup_action() {
		$this->set_integration( 'bravepop' );
		$this->set_action_code( 'OPENBRAVEPOPUP' );
		$this->set_action_meta( 'BRAVEPOPUPID' );
		/* translators: Action - WordPress */
		$this->set_sentence( sprintf( __( 'Open a {{Brave Popup:%s}}', 'bravepop' ), 'BRAVEPOPUPID' ));
		/* translators: Action - WordPress */
		$this->set_readable_sentence( esc_attr__( 'Open a {{Brave Popup}}', 'bravepop' ), 'BRAVEPOPUPID'  );

      $options = $this->bravepop_uncanny_all_brave_popups( $label = null, $option_code = 'BRAVEPOPUPID' );

      $this->set_options( $options );

		$this->register_action();
	}

   protected function bravepop_uncanny_all_brave_popups( $label = null, $option_code = 'BRAVEPOPUPID' ) {
 
      if ( ! $label ) {
         $label = esc_attr__( 'Popup', 'bravepop' );
      }
   
      //Load All Popups
      $args = array( 'numberposts' => -1, 'post_status'=> array('publish', 'draft')  , 'post_type' => 'popup', 'meta_query' => array( array( 'key' => 'popup_type', 'value' => 'popup','compare' => 'LIKE' ) )  );
      $options = Automator()->helpers->recipe->options->wp_query( $args, false, __( 'Any Popup', 'bravepop' ) );
   

      $option = array(Automator()->helpers->recipe->field->select(
         array(
            'option_code' => $option_code,
            'label'       => $label,
            'options'         => $options,
            'description' => 'Select the popup you want to show',
            'required'        => true,
            'input_type'  => 'select',
         )
      ));
   
      return $option;
   }
   

	/**
	 * @param int $user_id
	 * @param array $action_data
	 * @param int $recipe_id
	 * @param array $args
	 * @param $parsed
	 */
	protected function process_action( int $user_id, array $action_data, int $recipe_id, array $args, $parsed ) {

      if ( isset( $action_data['meta'][ 'BRAVEPOPUPID' ] ) ) {

         $popup_id = $action_data['meta'][ 'BRAVEPOPUPID' ];
         $popup_id = absint( $popup_id );
   
         add_action( 'wp_head', function () use ( $popup_id ) {
            global $bravepop_global;
            $alreadyLoaded = false;
   
            foreach ($bravepop_global['current_popups'] as $key => $item) {
               if($alreadyLoaded === false && ($item->id === $popup_id && $item->status === 'published')){
                  $alreadyLoaded = true;
               }
            }
            if($alreadyLoaded === false){
               $customContent = json_decode(get_post_meta($popup_id, 'popup_data', true));
               $customContent->settings->trigger->triggerType = 'load';
               new BravePop_Popup($popup_id, 'popup', false, false, json_encode($customContent) ); //insert the popup to the current page
            }
   
            ?>
            <?php
         }, 9 );
         
         Automator()->complete->action( $user_id, $action_data, $recipe_id );
      }
	}

}