/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.JPGWLib;

import Jp.BuySmart.JPGWLib.ActTable;
import Jp.BuySmart.JPGWLib.ComServer;
import Jp.BuySmart.JPGWLib.Config;
import Jp.BuySmart.JPGWLib.JPGWLibException;
import Jp.BuySmart.JPGWLib.MsgTable;
import Jp.BuySmart.JPGWLib.QueryString;
import Jp.BuySmart.JPGWLib.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Transaction {
    public static final String TXNVERSION = "2.0";
    public static final String CC_MSTATUS = "MStatus";
    public static final String CC_MERRLOC = "MErrLoc";
    public static final String CC_MERRMSG = "MErrMsg";
    public static final String CC_AUXMSG = "aux-msg";
    public static final String CC_ACTCODE = "action-code";
    public static final String CC_MSTATUS_SC = "success";
    public static final String CC_MSTATUS_FH = "failure-hard";
    public static final String CC_MSTATUS_FQC = "failure-q-or-cancel";
    public static final String CC_MSTATUS_FQD = "failure-q-or-discard";
    public static final String MDK_ERRLOC = "ccbsxlib";
    private static final int CARD_DIGIT_MAX = 26;
    private static final int RETRY = 2;
    private static final String[] DEP_TARGET_COMMANDS = new String[]{"authonly", "authcapture"};
    private static final String DEP_URI = "depgw/";
    private static final String DEP_PARAM_AD_FLAG = "ad-flag";
    private static final String DEP_PARAM_AD_CHARSET = "ad-charset";
    private static final String DEP_PARAM_AD_SCALE = "ad-scale";
    private Logger log = null;
    private Config conf = null;

    protected Transaction(Config conf) {
        this.conf = conf;
        this.log = Logger.getLogger(this.getClass());
    }

    public String getSecret() {
        return this.conf.getSecret();
    }

    public String getKeyHA1() {
        return this.conf.getKeyHA1();
    }

    public void setAcceptLanguage(String lang) {
        this.conf.setAcceptLanguage(lang);
    }

    public String getAcceptLanguage() {
        return this.conf.getAcceptLanguage();
    }

    public void setTimeOut(int sec) {
        this.conf.setTimeOut(sec);
    }

    public int getTimeOut() {
        return this.conf.getTimeOut();
    }

    public void setPendingDir(String pendingDir) {
        this.conf.setPendingDir(pendingDir);
    }

    public String getPendingDir() {
        return this.conf.getPendingDir();
    }

    public void setUsePendingLogging(boolean flag) {
        this.conf.setUsePendingLogging(flag);
    }

    public boolean getUsePendingLogging() {
        return this.conf.getUsePendingLogging();
    }

    public Hashtable sendMServer(String command, Hashtable args) {
        Hashtable response;
        block18: {
            this.log.info((Object)"== Entering SendMServer ==\n");
            response = null;
            try {
                if (command == null) {
                    throw new JPGWLibException(99000001);
                }
                if (this.conf.getCCPSHosts().size() == 0) {
                    throw new JPGWLibException(99000041, "CCPS_HOSTS");
                }
                if (this.conf.getUsePendingLogging()) {
                    this.checkPendingDirectory();
                }
                this.checkRequestFeild(command, args);
                this.checkCardDigit(args);
                this.addTxnVersion(args);
                if (command.equals("payrequest")) {
                    response = this.setPayrequestResponse(args);
                    throw new JPGWLibException(99000000);
                }
                if (this.isDepTarget(command, args)) {
                    this.addDepParameters(args);
                }
                String request = this.urlEncode2(args);
                Calendar calendar = Calendar.getInstance();
                Vector hosts = this.conf.getCCPSHosts();
                int hostNo = calendar.get(13) % hosts.size();
                this.log.info((Object)"Connecting to Payment GWY...\n");
                ComServer cs = new ComServer(this.conf, this.getTimeOut());
                String proxy = "";
                if (this.conf.getBool("USE_HTTP_PROXY")) {
                    proxy = this.conf.get("HTTP_PROXY_HOST");
                }
                for (int i = 0; i < 2; ++i) {
                    try {
                        String host = (String)hosts.elementAt(hostNo);
                        if (this.isDepTarget(command, args)) {
                            host = host + DEP_URI;
                        }
                        cs.start(host, proxy, this.conf.get("SECRET"), command, request);
                        break;
                    }
                    catch (JPGWLibException e2) {
                        if (e2.getCode() != 99000011 || i == 1) {
                            throw e2;
                        }
                        if (hostNo == hosts.size() - 1) {
                            hostNo = 0;
                            continue;
                        }
                        ++hostNo;
                        continue;
                    }
                }
                this.log.debug((Object)("SendMServer: response = " + Util.blindCardNumberRaw(cs.getResponseMessage()) + "\n"));
                response = this.urlDecode2(cs.getResponseMessage());
                if (response.get(CC_MSTATUS).equals(CC_MSTATUS_FQC) || response.get(CC_MSTATUS).equals(CC_MSTATUS_FQD)) {
                    this.pending(this.getSecret(), command, args);
                }
                this.replaseMessage(response);
            }
            catch (JPGWLibException e) {
                if (e.getCode() == 99000000) break block18;
                try {
                    if (e.getCode() == 99000031) {
                        this.pending(this.getSecret(), command, args);
                    }
                    response = this.setLocalError(e);
                }
                catch (JPGWLibException e2) {
                    response = this.setLocalError(e2);
                }
            }
        }
        this.log.info((Object)"== Exiting SendMServer ==\n\n");
        return response;
    }

    private void addTxnVersion(Hashtable args) throws JPGWLibException {
        if (args.containsKey("txn-version")) {
            this.log.error((Object)"override txn-version");
            throw new JPGWLibException(99000044);
        }
        args.put("txn-version", TXNVERSION);
    }

    private void checkCardDigit(Hashtable args) throws JPGWLibException {
        String card = (String)args.get("card-number");
        if (card != null && card.length() > 26) {
            throw new JPGWLibException(99000003, Util.blindCardNumber(card));
        }
    }

    private void checkPendingDirectory() throws JPGWLibException {
        File file = new File(this.conf.getPendingDir());
        if (!(file.isDirectory() && file.canWrite() && file.canRead())) {
            this.log.error((Object)("!!Checking a pending directory is fail. : " + file.getName() + "\n"));
            throw new JPGWLibException(99000045);
        }
    }

    private void checkRequestFeild(String command, Hashtable args) throws JPGWLibException {
        try {
            if (command.equals("mauthonly") || command.equals("authonly")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("amount")) {
                    throw new Exception("amount");
                }
                if (!args.containsKey("card-number")) {
                    throw new Exception("card-number");
                }
                if (!args.containsKey("card-exp")) {
                    throw new Exception("card-exp");
                }
            } else if (command.equals("mauthcapture") || command.equals("authcapture")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("amount")) {
                    throw new Exception("amount");
                }
                if (!args.containsKey("card-number")) {
                    throw new Exception("card-number");
                }
                if (!args.containsKey("card-exp")) {
                    throw new Exception("card-exp");
                }
            } else if (command.equals("postauth")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("amount")) {
                    throw new Exception("amount");
                }
            } else if (command.equals("void")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("txn-type")) {
                    throw new Exception("txn-type");
                }
            } else if (command.equals("return")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("amount")) {
                    throw new Exception("amount");
                }
            } else if (command.equals("payrequest")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("amount")) {
                    throw new Exception("amount");
                }
                if (!args.containsKey("note")) {
                    throw new Exception("note");
                }
            } else if (command.equals("retry")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
            } else if (command.equals("card-query")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("passwd")) {
                    throw new Exception("passwd");
                }
            } else if (command.equals("query-orders")) {
                if (!args.containsKey("start-time")) {
                    throw new Exception("start-time");
                }
                if (!args.containsKey("end-time")) {
                    throw new Exception("end-time");
                }
            } else if (command.equals("re-authonly")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("re-order-id")) {
                    throw new Exception("re-order-id");
                }
                if (!args.containsKey("amount")) {
                    throw new Exception("amount");
                }
            } else if (command.equals("re-authcapture")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("re-order-id")) {
                    throw new Exception("re-order-id");
                }
                if (!args.containsKey("amount")) {
                    throw new Exception("amount");
                }
            } else if (command.equals("directpostauth")) {
                if (!args.containsKey("order-id")) {
                    throw new Exception("order-id");
                }
                if (!args.containsKey("amount")) {
                    throw new Exception("amount");
                }
                if (!args.containsKey("card-number")) {
                    throw new Exception("card-number");
                }
                if (!args.containsKey("card-exp")) {
                    throw new Exception("card-exp");
                }
            }
        }
        catch (Exception e) {
            throw new JPGWLibException(99000002, e.getMessage());
        }
    }

    private String createPendingFilename() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd", Locale.US);
        return this.conf.getPendingDir() + "/" + formatter.format(new Date()) + ".csv";
    }

    private void pending(String secret, String command, Hashtable args) throws JPGWLibException {
        this.log.info((Object)"\t== Entering pending ==\n");
        this.log.error((Object)"!!Pending had occured.\n");
        if (!this.conf.getUsePendingLogging()) {
            this.log.debug((Object)"USE_PENDING_LOGGING == false, skip file logging.");
            return;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
        String text = formatter.format(new Date()) + ",";
        args.remove("txn-version");
        text = text + secret;
        text = text + ",";
        text = text + command;
        text = text + ",";
        Enumeration enumeration = args.keys();
        String key = null;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            text = text + key;
            text = text + ",";
            text = key.equals("card-number") ? text + Util.blindCardNumber((String)args.get(key)) : (key.indexOf("card-cav2") != -1 ? text + "****" : (key.indexOf("card-exp") != -1 ? text + "**/**" : text + (String)args.get(key)));
            if (!enumeration.hasMoreElements()) continue;
            text = text + ",";
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.createPendingFilename(), true);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(text);
            bw.newLine();
            bw.close();
        }
        catch (Exception e) {
            throw new JPGWLibException(99000043);
        }
        finally {
            this.log.info((Object)"\t== Exiting pending ==\n");
        }
    }

    private Hashtable replaseMessage(Hashtable response) {
        ActTable at;
        MsgTable mt = new MsgTable(this.conf.getPath("MSG_TABLE") + "." + this.conf.get("ACCEPT_LANG"));
        String key = CC_MERRMSG;
        String value = (String)response.get(key);
        if (value == null) {
            key = CC_AUXMSG;
            value = (String)response.get(key);
        }
        String code = this.stripMessageCode(value);
        if (mt.isRead()) {
            String message;
            if (code != null && (message = mt.find(code)) != null) {
                response.put(key, message);
                this.log.debug((Object)("\treplaceMessage: msg = " + message + "\n"));
            }
        } else {
            this.log.error((Object)("!!Cannot open message table: " + mt.getFile() + "!!\n"));
        }
        if ((at = new ActTable(this.conf.getPath("AC_TABLE"))).isRead()) {
            if (!response.containsKey(CC_ACTCODE)) {
                response.put(key, at.find(code));
                this.log.debug((Object)("\treplaceMessage: assign action-code: " + at.get(CC_ACTCODE) + "\n"));
            }
        } else {
            this.log.error((Object)("!!Cannot open action-code table: " + at.getFile() + "!!\n"));
        }
        return response;
    }

    private Hashtable setLocalError(JPGWLibException e) {
        this.log.debug((Object)"\t== Entering setLocalError ==\n");
        Hashtable<String, String> response = new Hashtable<String, String>();
        if (e.getCode() == 99000031) {
            response.put(CC_MSTATUS, CC_MSTATUS_FQC);
        } else {
            response.put(CC_MSTATUS, CC_MSTATUS_FH);
        }
        response.put(CC_MERRLOC, MDK_ERRLOC);
        MsgTable mt = new MsgTable(this.conf.getPath("MSG_TABLE") + "." + this.conf.get("ACCEPT_LANG"));
        response.put(CC_MERRMSG, mt.find(e.getCodeString(), e.getMessage()));
        if (!mt.isRead()) {
            response.put(CC_MERRMSG, "undefined message.");
            this.log.error((Object)("!!Cannot open message table: " + mt.getFile() + "!!\n"));
        }
        ActTable at = new ActTable(this.conf.getPath("AC_TABLE"));
        response.put(CC_ACTCODE, at.find(e.getCodeString()));
        if (!at.isRead()) {
            this.log.error((Object)("!!Cannot open action-code table: " + at.getFile() + "!!\n"));
        }
        this.log.debug((Object)("\t>> MStatus: [[" + response.get(CC_MSTATUS) + "]]\n"));
        this.log.debug((Object)("\t>> MErrLoc: [[" + response.get(CC_MERRLOC) + "]]\n"));
        this.log.debug((Object)("\t>> MErrMsg: [[" + response.get(CC_MERRMSG) + "]]\n"));
        this.log.debug((Object)("\t>> action-code: [[" + response.get(CC_ACTCODE) + "]]\n"));
        this.log.debug((Object)"\t== Exiting setLocalError ==\n");
        return response;
    }

    private Hashtable setPayrequestResponse(Hashtable args) throws JPGWLibException {
        this.log.debug((Object)"\t== Entering setPayrequestResponse ==\n");
        Hashtable<String, String> response = new Hashtable<String, String>();
        response.put(CC_MSTATUS, CC_MSTATUS_SC);
        response.put(CC_ACTCODE, "000");
        response.put("order-id", (String)args.get("order-id"));
        response.put("amount", (String)args.get("amount"));
        response.put("note", (String)args.get("note"));
        response.put("accepts", this.conf.get("ACCEPTS"));
        response.put("url-pay-to", this.conf.get("URL_PAY_TO"));
        this.log.debug((Object)"\t== Exiting setPayrequestResponse ==\n");
        return response;
    }

    private String stripMessageCode(String message) {
        String code = null;
        try {
            int idx = message.indexOf(":");
            code = idx != -1 ? message.substring(0, idx) : message;
            Integer.parseInt(code.trim());
        }
        catch (Exception e) {
            code = null;
        }
        return code;
    }

    private Hashtable urlDecode2(String value) {
        this.log.debug((Object)"\t== Entering urlDecode ==\n");
        QueryString qs = new QueryString(value, 3);
        Enumeration enumeration = qs.keys();
        String key = null;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            if (key.indexOf("card-number") != -1) {
                this.log.debug((Object)("\t>> " + key + ": [[" + Util.blindCardNumber(qs.get(key)) + "]]\n"));
                continue;
            }
            if (key.indexOf("card-cav2") != -1) {
                this.log.debug((Object)("\t>> " + key + ": [[****]]\n"));
                continue;
            }
            if (key.indexOf("card-exp") != -1) {
                this.log.debug((Object)("\t>> " + key + ": [[**/**]]\n"));
                continue;
            }
            this.log.debug((Object)("\t>> " + key + ": [[" + qs.get(key) + "]]\n"));
        }
        this.log.debug((Object)"\t== Exiting urlDecode ==\n");
        return qs;
    }

    private String urlEncode2(Hashtable args) {
        this.log.debug((Object)"\t== Entering urlEncode ==\n");
        QueryString qs = new QueryString(args, 2);
        Enumeration enumeration = qs.keys();
        String key = null;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            if (key.indexOf("card-number") != -1) {
                this.log.debug((Object)("\t<< " + key + ": [[" + Util.blindCardNumber(qs.get(key)) + "]]\n"));
                continue;
            }
            if (key.indexOf("card-cav2") != -1) {
                this.log.debug((Object)("\t<< " + key + ": [[****]]\n"));
                continue;
            }
            if (key.indexOf("card-exp") != -1) {
                this.log.debug((Object)("\t<< " + key + ": [[**/**]]\n"));
                continue;
            }
            this.log.debug((Object)("\t<< " + key + ": [[" + qs.get(key) + "]]\n"));
        }
        this.log.debug((Object)"\t== Exiting urlEncode ==\n");
        return qs.toString();
    }

    private void addDepParameters(Hashtable args) {
        this.addDepParam(args, DEP_PARAM_AD_FLAG, this.conf.getAdFlag());
        this.addDepParam(args, DEP_PARAM_AD_CHARSET, this.conf.getAdCharset());
        this.addDepParam(args, DEP_PARAM_AD_SCALE, this.conf.getAdScale());
    }

    private void addDepParam(Hashtable args, String paramName, String value) {
        if (args.containsKey(paramName)) {
            return;
        }
        args.put(paramName, value);
    }

    private boolean isDepTarget(String command, Hashtable args) {
        boolean isDepTarget = false;
        String strAdFlag = this.conf.getAdFlag();
        String paramAdFlag = (String)args.get(DEP_PARAM_AD_FLAG);
        if (paramAdFlag != null && !paramAdFlag.equals("")) {
            strAdFlag = paramAdFlag;
        }
        if (command == null || strAdFlag == null || strAdFlag.equals("")) {
            return isDepTarget;
        }
        int adFlag = -1;
        try {
            adFlag = Integer.parseInt(strAdFlag);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (adFlag <= 0) {
            return isDepTarget;
        }
        for (int i = 0; i < DEP_TARGET_COMMANDS.length; ++i) {
            if (!command.equals(DEP_TARGET_COMMANDS[i])) continue;
            isDepTarget = true;
            break;
        }
        return isDepTarget;
    }
}

