/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.JPGWLib;

import Jp.BuySmart.JPGWLib.JPGWLibException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String hmac(String provider, String algorithm, String key, String value) throws JPGWLibException {
        int key_len = key.length() / 2;
        StringBuffer sb = null;
        try {
            Security.addProvider((Provider)Class.forName(provider).newInstance());
            byte[] keyByte = new byte[key_len];
            for (int i = 0; i < key_len; ++i) {
                keyByte[i] = (byte)Integer.parseInt(key.substring(i * 2, i * 2 + 2), 16);
            }
            SecretKeySpec sk = new SecretKeySpec(keyByte, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(sk);
            byte[] result = mac.doFinal(value.getBytes());
            sb = new StringBuffer();
            for (int i = 0; i < result.length; ++i) {
                sb.append(HEX[Crypto.byte2int(result[i]) / 16]);
                sb.append(HEX[Crypto.byte2int(result[i]) % 16]);
            }
        }
        catch (Exception e) {
            throw new JPGWLibException(99000046);
        }
        return sb.toString();
    }

    private static int byte2int(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }
}

