/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.JPGWLib;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class SignatureHelper {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String SIG_SEPARATOR = ":";
    private static SignatureHelper instance = new SignatureHelper();

    private SignatureHelper() {
    }

    public static SignatureHelper getInstance() {
        return instance;
    }

    private int byte2int(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    public String sign(String id, String key, String msg) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        md.update(id.getBytes());
        md.update(SIG_SEPARATOR.getBytes());
        md.update(key.getBytes());
        md.update(SIG_SEPARATOR.getBytes());
        md.update(msg.getBytes());
        byte[] b = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buf.append(HEX[this.byte2int(b[i]) / 16]);
            buf.append(HEX[this.byte2int(b[i]) % 16]);
        }
        return buf.toString();
    }

    public boolean verify(String id, String key, String msg, String sig) {
        return sig.equals(this.sign(id, key, msg));
    }

    public String createToken(String id) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        md.update(id.getBytes());
        md.update(Long.toHexString(System.currentTimeMillis()).getBytes());
        byte[] b = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buf.append(HEX[this.byte2int(b[i]) / 16]);
            buf.append(HEX[this.byte2int(b[i]) % 16]);
        }
        return buf.toString();
    }
}

