/*
 * Decompiled with CFR 0.152.
 */
package CCKK.CCBSXLib;

import CCKK.CCBSXLib.CCConfig;
import CCKK.CCBSXLib.CCCrypto;
import CCKK.CCBSXLib.CCDebug;
import CCKK.CCBSXLib.CCException;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

public class CCComServer {
    private final String CCVERSION = "1.0.1";
    private final String UA_LANG = "JAVA";
    private final String CC_CONTENT_TYPE = "Content-type: application/x-www-form-urlencoded";
    private final String HMAC_ALGORITHM = "HMAC-SHA1-160";
    private final String CONTENT_LENGTH = "Content-Length";
    private final int CL_TAG_LEN = "Content-Length".length();
    private final String KEYSTORE_PASSWD = "BuySmartFlex";
    private int timeout = 0;
    private int code = -1;
    private String message = null;
    private CCDebug log = null;
    private CCConfig conf = null;
    private boolean https = false;
    private Socket socket = null;
    private Socket tunnel = null;
    DataOutputStream dos = null;
    BufferedReader br = null;
    DataOutputStream t_dos = null;
    BufferedReader t_br = null;
    private String trust_hosts = "pay1.cybercash.co.jp pay2.cybercash.co.jp pay3.cybercash.co.jp pay4.cybercash.co.jp pay5.cybercash.co.jp pay6.cybercash.co.jp pay7.cybercash.co.jp pay8.cybercash.co.jp pay9.cybercash.co.jp";

    public CCComServer(CCConfig cCConfig, CCDebug cCDebug, int n) {
        this.conf = cCConfig;
        this.log = cCDebug;
        this.timeout = n;
    }

    private void checkCertificate() throws CCException {
        try {
            ((SSLSocket)this.socket).startHandshake();
            SSLSession sSLSession = ((SSLSocket)this.socket).getSession();
            X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
            boolean bl = false;
            String string = null;
            String string2 = "";
            int n = 0;
            while (n < x509CertificateArray.length) {
                String string3 = x509CertificateArray[n].getSubjectDN().toString();
                int n2 = string3.indexOf("CN=");
                if (n2 != -1) {
                    int n3 = string3.indexOf(",", n2 += 3);
                    if (bl = this.isTrustHost(string = n3 != -1 ? string3.substring(n2, n3) : string3.substring(n2))) break;
                    string2 = String.valueOf(string) + " ";
                }
                ++n;
            }
            if (!bl) {
                this.log.write(1, "!!mismatch host name: " + string2 + "\n");
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new CCException(99000011);
        }
    }

    private void checkHttpStatusCode() throws CCException {
        switch (this.code) {
            case 401: {
                throw new CCException(99000014);
            }
            case 403: {
                throw new CCException(99000015);
            }
            case 404: {
                throw new CCException(99000016);
            }
            case 500: {
                throw new CCException(99000017);
            }
            case 501: {
                throw new CCException(99000018);
            }
            case 503: {
                throw new CCException(99000019);
            }
            default: {
                throw new CCException(99000020, String.valueOf(this.code));
            }
            case 200: 
        }
    }

    private void checkProtocol(String string) throws CCException {
        this.https = string.startsWith("https://");
        if (!this.https && !string.startsWith("http://")) {
            throw new CCException(99000011);
        }
    }

    private void doTunnelHandshake(String string, int n) throws CCException {
        try {
            this.t_dos = new DataOutputStream(this.tunnel.getOutputStream());
            this.t_dos.writeBytes("CONNECT " + string + ":" + n + " HTTP/1.0\r\n\r\n");
            this.t_dos.flush();
            this.t_br = new BufferedReader(new InputStreamReader(this.tunnel.getInputStream(), "8859_1"));
            String string2 = this.t_br.readLine();
            String string3 = null;
            while (string2 != null && (string3 = this.t_br.readLine()) != null) {
                if (string3.length() == 0) break;
            }
            if (string2 == null || !string2.startsWith("HTTP/1.0 200")) {
                throw new CCException(99000011);
            }
        }
        catch (CCException cCException) {
            throw cCException;
        }
        catch (IOException iOException) {
            if (this.t_br == null) {
                throw new CCException(99000010);
            }
            throw new CCException(99000011);
        }
        catch (Exception exception) {
            throw new CCException(99000011);
        }
    }

    public int getResponseCode() {
        return this.code;
    }

    public String getResponseMessage() {
        return this.message;
    }

    private boolean isTrustHost(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(this.trust_hosts);
        while (!bl && stringTokenizer.hasMoreTokens()) {
            if (!string.equals(stringTokenizer.nextToken())) continue;
            bl = true;
        }
        return bl;
    }

    private Hashtable parseUrl(String string) throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        int n2 = 0;
        n = string.indexOf("://");
        hashtable.put("protocol", string.substring(0, n));
        n2 = string.indexOf(":", n + 3);
        hashtable.put("host", string.substring(n + 3, n2));
        n = n2;
        n2 = string.indexOf("/", n);
        hashtable.put("port", string.substring(n + 1, n2));
        hashtable.put("uri", string.substring(n2));
        return hashtable;
    }

    private void receiveData() throws CCException {
        this.log.write(7, "== Reading payment server response ==\n");
        String string = "";
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            int n;
            int n2;
            this.br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "8859_1"));
            String string2 = null;
            string2 = this.br.readLine();
            if (string2 != null) {
                n2 = string2.indexOf(" ");
                if (n2 == -1) {
                    throw new CCException(99000022);
                }
            } else {
                throw new CCException(99000013);
            }
            String string3 = string2.substring(n2 + 1, n2 + 4);
            this.code = Integer.parseInt(string3);
            string = String.valueOf(string) + string2;
            string = String.valueOf(string) + "\r\n";
            n2 = 0;
            int n3 = -1;
            while ((string2 = this.br.readLine()) != null) {
                if (string2.length() == 0) break;
                if (string2.compareToIgnoreCase("Transfer-Encoding: chunked") == 0) {
                    n2 = 1;
                }
                if (string2.toLowerCase().startsWith("Content-Length".toLowerCase())) {
                    n = string2.indexOf(":");
                    if (n == -1) {
                        throw new CCException(99000022);
                    }
                    String string4 = string2.substring(n + 2);
                    n3 = Integer.parseInt(string4, 10);
                }
                string = String.valueOf(string) + string2;
                string = String.valueOf(string) + "\r\n";
            }
            string = String.valueOf(string) + "\r\n";
            if (n2 != 0) {
                while ((string2 = this.br.readLine()) != null) {
                    int n4 = Integer.parseInt(string2, 16);
                    if (n4 == 0) {
                        string2 = this.br.readLine();
                        break;
                    }
                    char[] cArray = new char[n4];
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n4) {
                        if (!this.br.ready()) continue;
                        n5 = this.br.read(cArray, 0, n4 - n6);
                        if (n5 == -1) break;
                        n6 += n5;
                        stringBuffer.append(cArray, 0, n5);
                    }
                    if (n4 != n6) {
                        throw new Exception();
                    }
                    cArray = null;
                    this.br.readLine();
                }
            } else if (n3 > -1) {
                char[] cArray = new char[n3];
                int n7 = 0;
                int n8 = 0;
                while (n8 < n3) {
                    if (!this.br.ready()) continue;
                    n7 = this.br.read(cArray, 0, n3 - n8);
                    if (n7 == -1) break;
                    n8 += n7;
                    stringBuffer.append(cArray, 0, n7);
                }
                if (n3 != n8) {
                    throw new Exception();
                }
            } else {
                char[] cArray = new char[4096];
                int n9 = this.br.read(cArray, 0, cArray.length);
                while (n9 > 0) {
                    stringBuffer.append(cArray, 0, n9);
                    n9 = this.br.read(cArray, 0, cArray.length);
                    if (n9 != 0) continue;
                    System.err.println("cur == 0!!!");
                }
            }
            n = string.length() + stringBuffer.length();
            this.log.write(9, "recieve data(" + n + "):\n" + string + CCDebug.blindCardNumberRaw(stringBuffer.toString()) + "\n");
            this.message = stringBuffer.toString();
        }
        catch (CCException cCException) {
            throw cCException;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new CCException(99000013);
        }
        catch (IOException iOException) {
            throw new CCException(99000013);
        }
        catch (Exception exception) {
            throw new CCException(99000022);
        }
    }

    private void sendData(String string, String string2) throws CCException {
        boolean bl = false;
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            String string3 = CCCrypto.hmac("HmacSHA1", this.conf.get("KEY_HA1"), string2);
            String string4 = "POST " + string + " HTTP/1.0\r\n" + "User-Agent: CCBSXLib/" + "1.0.1" + "(" + "JAVA" + ")\r\n" + "Content-type: application/x-www-form-urlencoded" + "\r\n" + "Content-length: " + string2.length() + "\r\n" + "Content-HMAC: h=" + "HMAC-SHA1-160" + "; value=" + string3 + "\r\n" + "Accept-Language: " + this.conf.get("ACCEPT_LANG") + "\r\n\r\n";
            this.log.write(9, "Send request.\n");
            dataOutputStream.writeBytes(string4);
            dataOutputStream.writeBytes(string2);
            dataOutputStream.flush();
            bl = true;
            this.log.write(9, "Send data\n" + string4 + CCDebug.blindCardNumberRaw(string2) + "\n");
        }
        catch (CCException cCException) {
            throw cCException;
        }
        catch (Exception exception) {
            if (bl) {
                throw new CCException(99000013);
            }
            throw new CCException(99000010);
        }
    }

    public void start(String string, String string2, String string3, String string4, String string5) throws CCException {
        this.log.write(7, "=== SENDMSERVER to host=" + string + ", secret=" + string3 + ", command=" + string4 + ", proxy=" + string2 + " ===\n");
        try {
            if (!string.endsWith("/")) {
                string = String.valueOf(string) + "/";
            }
            String string6 = String.valueOf(string) + string3 + "/" + string4;
            this.checkProtocol(string);
            Hashtable hashtable = this.parseUrl(string6);
            if (this.https) {
                this.useHttpsConnect((String)hashtable.get("host"), Integer.parseInt((String)hashtable.get("port")), (String)hashtable.get("uri"), string2, string5);
            } else {
                this.useHttpConnect((String)hashtable.get("host"), Integer.parseInt((String)hashtable.get("port")), (String)hashtable.get("uri"), string2, string5);
            }
            this.checkHttpStatusCode();
        }
        catch (CCException cCException) {
            boolean bl = string4.equals("authonly") || string4.equals("mauthonly") || string4.equals("authcapture") || string4.equals("mauthcapture") || string4.equals("postauth") || string4.equals("void") || string4.equals("return") || string4.equals("retry");
            switch (cCException.getCode()) {
                case 99000013: {
                    this.log.write(1, "!!Connected timeout.\n");
                    if (!bl) break;
                    throw new CCException(99000031);
                }
                case 99000011: {
                    this.log.write(1, "!!Could not connect payment server: " + string + ".\n");
                    break;
                }
                case 99000012: {
                    this.log.write(1, "!!Could not connect proxy server: " + string2 + ".\n");
                    break;
                }
                case 99000010: {
                    this.log.write(1, "!!error writing  to socket.\n");
                    break;
                }
                case 99000046: {
                    this.log.write(1, "!!fail to calculate HMAC.\n");
                    break;
                }
                case 99000022: {
                    if (!bl) break;
                    throw new CCException(99000031);
                }
            }
            throw cCException;
        }
        catch (Exception exception) {
            this.log.write(1, "!!Could not connect payment server: " + string + ".\n");
            throw new CCException(99000011);
        }
    }

    private void useHttpConnect(String string, int n, String string2, String string3, String string4) throws CCException {
        try {
            try {
                if (string3 != null && string3.length() != 0) {
                    URL uRL = new URL("http://" + string3);
                    this.socket = new Socket(uRL.getHost(), uRL.getPort());
                    this.socket.setSoTimeout(this.timeout * 1000);
                    this.sendData("http://" + string + ":" + n + string2, string4);
                } else {
                    this.socket = new Socket(string, n);
                    this.socket.setSoTimeout(this.timeout * 1000);
                    this.sendData(string2, string4);
                }
                this.receiveData();
            }
            catch (CCException cCException) {
                throw cCException;
            }
            catch (Exception exception) {
                if (string3 != null && string3.length() != 0) {
                    throw new CCException(99000012);
                }
                throw new CCException(99000011);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (this.dos != null) {
                this.dos.close();
            }
            if (this.br != null) {
                this.br.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {}
    }

    private void useHttpsConnect(String string, int n, String string2, String string3, String string4) throws CCException {
        Security.addProvider((java.security.Provider)new Provider());
        try {
            try {
                Object object;
                SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509");
                KeyStore keyStore = null;
                try {
                    keyStore = KeyStore.getInstance("JKS");
                    object = new File(this.conf.get("CERT_FILE"));
                    keyStore.load(new FileInputStream((File)object), "BuySmartFlex".toCharArray());
                }
                catch (Exception exception) {
                    this.log.write(1, "!!fail to use a certificate file: " + this.conf.get("CERT_FILE") + "!!\n");
                    throw new CCException(99000011);
                }
                trustManagerFactory.init(keyStore);
                sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
                object = sSLContext.getSocketFactory();
                if (string3 != null && string3.length() != 0) {
                    URL uRL = new URL("http://" + string3);
                    this.tunnel = new Socket(uRL.getHost(), uRL.getPort());
                    this.tunnel.setSoTimeout(this.timeout * 1000);
                    this.doTunnelHandshake(string, n);
                    this.socket = (SSLSocket)((SSLSocketFactory)object).createSocket(this.tunnel, string, n, true);
                    this.socket.setSoTimeout(this.timeout * 1000);
                    this.checkCertificate();
                    this.sendData("https://" + string + ":" + n + string2, string4);
                } else {
                    this.socket = (SSLSocket)((SocketFactory)object).createSocket(string, n);
                    this.socket.setSoTimeout(this.timeout * 1000);
                    this.checkCertificate();
                    this.sendData(string2, string4);
                }
                this.receiveData();
            }
            catch (CCException cCException) {
                throw cCException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log.write(1, "\tcan't create SSL Context\n");
                throw new CCException(99000011);
            }
            catch (Exception exception) {
                if (string3 != null && string3.length() != 0) {
                    throw new CCException(99000012);
                }
                throw new CCException(99000011);
            }
            Object var7_12 = null;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            try {
                if (this.dos != null) {
                    this.dos.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
                if (this.tunnel != null) {
                    this.tunnel.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (this.dos != null) {
                this.dos.close();
            }
            if (this.br != null) {
                this.br.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.tunnel != null) {
                this.tunnel.close();
            }
        }
        catch (Exception exception) {}
    }
}

