/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MdkUtil {
    private static final Pattern URL_PORT = Pattern.compile("^http[s]*://([^:/]*):([0-9]+)([/]?|/.*)$");
    private static final String ASTER = "*";
    private static Set maskSet = null;

    public static String toLowerFieldName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String toUpperFieldName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String bytes2Hex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (n2 < 16) {
                stringBuffer = stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n2));
        }
        return stringBuffer.toString();
    }

    public static String[] getHostAndPort(String string) {
        if (string == null) {
            return new String[0];
        }
        Matcher matcher = URL_PORT.matcher(string);
        String[] stringArray = null;
        stringArray = matcher.find() ? new String[]{matcher.group(1), matcher.group(2)} : new String[]{};
        return stringArray;
    }

    public static String getPackageName(Class clazz) {
        String string = clazz.getName();
        return string.substring(0, string.lastIndexOf("."));
    }

    public static String maskData(String string, String string2) {
        if (maskSet == null) {
            MdkUtil.setMaskSet();
        }
        if (string == null || string2 == null) {
            return null;
        }
        if (!maskSet.contains(string2)) {
            return string;
        }
        String string3 = string;
        if (string2.toUpperCase().indexOf("MAILADDR") >= 0) {
            int n = string.indexOf("@");
            if (n >= 0) {
                string3 = string.substring(0, n).replaceAll(".", ASTER) + string.substring(n);
            }
        } else if (string2.toUpperCase().indexOf("CARDNUMBER") >= 0) {
            if (string3.length() > 4) {
                string3 = string.substring(0, 4) + string.substring(4).replaceAll(".", ASTER);
            }
        } else {
            string3 = string.replaceAll(".", ASTER);
        }
        return string3;
    }

    public static String maskXml(String string) {
        if (maskSet == null) {
            MdkUtil.setMaskSet();
        }
        if (string == null) {
            return null;
        }
        Pattern pattern = null;
        Matcher matcher = null;
        String string2 = string;
        Iterator iterator = maskSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            pattern = string3.toUpperCase().indexOf("MAILADDR") >= 0 ? Pattern.compile("(<" + string3 + ">[\\t|\\r|\\n|\\s]*)([^@<]*)(@[^<]*</" + string3 + ">)", 32) : (string3.toUpperCase().indexOf("CARDNUMBER") >= 0 ? Pattern.compile("(<" + string3 + ">[\\t|\\r|\\n|\\s]*[^<]{4})([^<]*)(</" + string3 + ">)", 32) : Pattern.compile("(<" + string3 + ">[\\t|\\r|\\n|\\s]*)([^<]*)(</" + string3 + ">)", 32));
            matcher = pattern.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, matcher.group(1) + matcher.group(2).replaceAll(".", ASTER) + matcher.group(3));
            }
            string2 = matcher.appendTail(stringBuffer).toString();
        }
        return string2;
    }

    public static void setMaskSet() {
        maskSet = new HashSet();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("mdkinternal");
        String string = resourceBundle.getString("MASK_ITEM");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            maskSet.add(stringTokenizer.nextToken());
        }
    }

    public static String deleteRN(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[\r\n]+");
        String[] stringArray = pattern.split(string);
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i].replaceAll("^[ \t]+", ""));
        }
        return stringBuffer.toString();
    }
}

