/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ResourceBundle;

public class MdkLocalException
extends Exception {
    private static final long serialVersionUID = 5407368234302064771L;
    public static final String CONFIG_MISSING = "MA01";
    public static final String CONFIG_VALUE_INVALID = "MA02";
    public static final String FILE_NO_EXIST = "MA03";
    public static final String ENCRYPTION_ERROR = "MA04";
    public static final String DECRYPTION_ERROR = "MA06";
    public static final String TYPEA_INTERNAL_ERROR = "MA99";
    public static final String NO_CONFIG_FILE = "MB01";
    public static final String CONFIG_READ_ERROR = "MB02";
    public static final String SOCKET_FACTORY_CREATION_ERROR = "MB03";
    public static final String NO_SUCH_ALGORITHM_ERROR = "MB98";
    public static final String TYPEB_INTERNAL_ERROR = "MB99";
    public static final String PROXY_CONNECT_ERROR = "MF01";
    public static final String GW_CONNECT_ERROR = "MF02";
    public static final String SERVER_TIME_OUT = "MF03";
    public static final String SOCKET_IO_ERROR = "MF04";
    public static final String INTERNAL_SERVER_ERROR = "MF05";
    public static final String BAD_GW = "MF06";
    public static final String SERVICE_UNAVAILABLE = "MF07";
    public static final String TYPEF_INTERNAL_ERROR = "MF99";
    private String errorCode;
    private String merrMsg;
    private Throwable cause = null;
    private static ResourceBundle rb = ResourceBundle.getBundle("errormessage");

    private MdkLocalException() {
    }

    public MdkLocalException(String string) {
        this();
        this.errorCode = string;
        this.merrMsg = rb.getString(string);
    }

    public MdkLocalException(String string, String string2) {
        super(string);
        this.errorCode = string2;
        this.merrMsg = rb.getString(string2);
    }

    public MdkLocalException(String string, String string2, String[] stringArray) {
        super(string);
        this.errorCode = string2;
        String string3 = rb.getString(string2);
        if (CONFIG_MISSING.equals(string2) || CONFIG_VALUE_INVALID.equals(string2) || FILE_NO_EXIST.equals(string2)) {
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = string3.replaceFirst("%s", stringArray[i]);
            }
        }
        this.merrMsg = string3;
    }

    public MdkLocalException(String string, String string2, Throwable throwable) {
        super(string);
        this.cause = throwable;
        this.errorCode = string2;
        this.merrMsg = rb.getString(string2);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMerrMsg() {
        return this.merrMsg;
    }

    public static String convertErrorCode(String string) {
        return rb.getString(string);
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.cause != null) {
            this.cause.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.cause != null) {
            this.cause.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.cause != null) {
            this.cause.printStackTrace(printWriter);
        }
    }

    public static MdkLocalException getMissingException(String string) {
        return new MdkLocalException(string + " is missing", CONFIG_MISSING, new String[]{string});
    }

    public static MdkLocalException getFileNotExistException(String string, String string2) {
        return new MdkLocalException(string + " does not exist", FILE_NO_EXIST, new String[]{string, string2});
    }

    public static MdkLocalException getInvalidValueException(String string, String string2) {
        return new MdkLocalException("Invalid " + string + ". Value is " + string2, CONFIG_VALUE_INVALID, new String[]{string, string2});
    }
}

