/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.veritrans.tercerog.mdk.ITransaction;
import jp.veritrans.tercerog.mdk.MdkContentHandler;
import jp.veritrans.tercerog.mdk.MerchantConfig;
import jp.veritrans.tercerog.mdk.NVQuery;
import jp.veritrans.tercerog.mdk.connection.SettlementDemandServlet;
import jp.veritrans.tercerog.mdk.connection.ssl.SSLConfigurator;
import jp.veritrans.tercerog.mdk.context.MerchantContext;
import jp.veritrans.tercerog.mdk.dto.IBaseDto;
import jp.veritrans.tercerog.mdk.exception.MdkLocalException;
import jp.veritrans.tercerog.mdk.gw.utils.EncryptionUtils;
import jp.veritrans.tercerog.mdk.gw.utils.HashUtils;
import jp.veritrans.tercerog.mdk.util.MdkUtil;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Transaction
implements ITransaction {
    public static final Pattern OPTION_PATTERN = Pattern.compile("[\\s|\\t|\\r|\\n]*<optionResults>.*</optionResults>[\\s|\\t|\\r|\\n]*", 32);
    public static final Pattern PATTERN_HTTP_RETURN = Pattern.compile("^[^\\s]*\\s(\\d{3})\\s");
    public static final int HTTP_RETURN_NORMAL = 200;
    public static final int AUTHENTICATION_REQUIRED = 407;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final String VRESULT_RIGHT0 = "000000000000";
    public static final String GMT = "GMT";
    public static final String SET_MASKED_LOG = "_setMaskedLog";
    public static final String SET_RESULT_XML = "_setResultXml";
    public static final String QUESTION = "?";
    public static final String TLS = "TLS";
    private Logger logger = null;
    private MerchantContext context;
    private String responseHeader = null;
    private String response = null;

    private Transaction() {
    }

    public Transaction(MerchantContext merchantContext) {
        this();
        this.logger = Logger.getLogger(this.getClass());
        this.context = merchantContext;
    }

    public Object execute() {
        Object object = null;
        IBaseDto iBaseDto = this.context.getBaseDto();
        try {
            Object object2;
            Object object3;
            Object object4;
            StringBuffer stringBuffer = new StringBuffer();
            MerchantConfig merchantConfig = this.context.getMerchantConfig();
            String string = merchantConfig.getProperty("MDK_VERSION");
            String string2 = merchantConfig.getProperty("MDK_DTO_VERSION");
            this.logger.debug((Object)("========== Transaction#execute() start [" + string + "/" + string2 + "] =========="));
            try {
                object4 = Class.forName(this.context.getResponseDtoName());
                object = ((Class)object4).newInstance();
            }
            catch (Exception exception) {
                this.logger.error((Object)("!!!!!!!!!! Unable to create response dto(" + this.context.getResponseDtoName() + "). Abnormal dto, check jar file !!!!!!!!!!"));
                throw new MdkLocalException("Response dto creation failed. " + this.getOriginalMessage(exception), "MF99", exception);
            }
            merchantConfig.checkMerchantConfig();
            object4 = new NVQuery(this.context);
            stringBuffer.append(((NVQuery)object4).getNVofDto(""));
            String string3 = ((NVQuery)object4).getLogNV();
            try {
                object3 = iBaseDto.getClass().getMethod(SET_MASKED_LOG, String.class);
                ((Method)object3).invoke((Object)iBaseDto, string3);
            }
            catch (Exception exception) {
                this.logger.error((Object)"!!!!!!!!!! Unable to set log message to request dto. Abnormal dto, check jar file !!!!!!!!!!");
                throw new MdkLocalException("Respose dto does not have method. " + this.getOriginalMessage(exception), "MA99", exception);
            }
            object3 = new StringBuffer();
            ((StringBuffer)object3).append(this.editNVofConfig("txnVersion", "MDK_DTO_VERSION"));
            ((StringBuffer)object3).append(this.editNVofConfig("dummyRequest", "DUMMY_REQUEST"));
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(GMT));
            ((StringBuffer)object3).append("&").append("requestDatetimeGMT").append("=").append(simpleDateFormat.format(date));
            ((StringBuffer)object3).append(this.editNVofConfig("merchantCcid", "MERCHANT_CCID"));
            this.logger.debug((Object)("========== connect 3gw url  ==> " + this.context.getMerchantConfig().getProperty("SERVER_URL")));
            this.logger.debug((Object)("========== request mct data ==> " + string3.toString()));
            this.logger.debug((Object)("========== request mdk data ==> " + ((StringBuffer)object3).toString()));
            stringBuffer.append(((StringBuffer)object3).toString());
            this.context.setOriginalNameAndValues(stringBuffer.toString());
            try {
                stringBuffer = new StringBuffer(new String(stringBuffer.toString().getBytes("UTF-8"), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.logger.error((Object)"!!!!!!!!!! UTF-8 is not supported in your server. !!!!!!!!!!");
                throw new MdkLocalException("Encode error" + this.getOriginalMessage(unsupportedEncodingException), "MB99", unsupportedEncodingException);
            }
            try {
                object2 = HashUtils.getInstance().getDigest(new String[]{merchantConfig.getProperty("MERCHANT_CCID"), stringBuffer.toString(), merchantConfig.getProperty("MERCHANT_SECRET_KEY")});
                stringBuffer.append("&").append("authHash").append("=").append((String)object2);
            }
            catch (Exception exception) {
                this.logger.error((Object)"!!!!!!!!!! Unable to calculate message digest. !!!!!!!!!!");
                throw new MdkLocalException("Error has occurred while calculating message digest. " + this.getOriginalMessage(exception), "MA04", exception);
            }
            this.context.setNameAndValues(stringBuffer.toString());
            this.send();
            this.setResponseXml(object);
            object2 = OPTION_PATTERN.matcher(this.response);
            String string4 = "";
            if (((Matcher)object2).find()) {
                string4 = ((Matcher)object2).replaceFirst("");
            } else if (this.response.indexOf("<optionResults/>") >= 0) {
                string4 = this.response;
                string4 = this.response.replaceFirst("<optionResults/>", "");
            }
            try {
                this.setResponseToDto(object, string4);
            }
            catch (MdkLocalException mdkLocalException) {
                Class<?> clazz = Class.forName(this.context.getResponseDtoName());
                object = clazz.newInstance();
                this.setResponseXml(object);
                throw mdkLocalException;
            }
        }
        catch (Exception exception) {
            object = this.errorProcess(iBaseDto, object, exception);
        }
        this.logger.debug((Object)"========== Transaction.execute() end ==========");
        return object;
    }

    private String editNVofConfig(String string, String string2) {
        return "&" + string + "=" + this.context.getMerchantConfig().getProperty(string2);
    }

    private void send() throws MdkLocalException {
        block5: {
            MerchantConfig merchantConfig = this.context.getMerchantConfig();
            SSLConfigurator sSLConfigurator = this.createSSLConfigurator();
            String string = null;
            try {
                this.bodyBase64Encode();
                String string2 = this.context.getNameAndValues();
                URL uRL = new URL(merchantConfig.getProperty("SERVER_URL") + QUESTION + string2);
                SettlementDemandServlet settlementDemandServlet = new SettlementDemandServlet(sSLConfigurator, merchantConfig.getUserAgent());
                settlementDemandServlet.execute(2, uRL);
                string = settlementDemandServlet.getResultHeader();
                this.responseHeader = string != null ? string : "";
                string = settlementDemandServlet.getResultBody();
                this.response = string != null ? string : "";
                Matcher matcher = PATTERN_HTTP_RETURN.matcher(this.responseHeader);
                if (matcher.find()) {
                    String string3 = matcher.group(1);
                    int n = Integer.parseInt(string3);
                    if (n != 200) {
                        String string4 = Transaction.httpError(n);
                        this.logger.error((Object)("!!!!!!!!!! Http response : Http response header       ==> " + this.responseHeader + " !!!!!!!!!!"));
                        this.logger.error((Object)("!!!!!!!!!! Http response : Http response message      ==> " + this.response + " !!!!!!!!!!"));
                        throw new MdkLocalException("Http response error. Value " + n + ". ", string4);
                    }
                    break block5;
                }
                this.logger.error((Object)("!!!!!!!!!! Http response format error, no httpReturn . Http response header ==> " + this.responseHeader + " !!!!!!!!!!"));
                throw new MdkLocalException("Http response format error", "MF99");
            }
            catch (MdkLocalException mdkLocalException) {
                throw mdkLocalException;
            }
            catch (Exception exception) {
                throw this.getSendException(exception);
            }
        }
    }

    private SSLConfigurator createSSLConfigurator() {
        MerchantConfig merchantConfig = this.context.getMerchantConfig();
        SSLConfigurator sSLConfigurator = new SSLConfigurator();
        sSLConfigurator.setProtocol(TLS);
        sSLConfigurator.setTimeoutSec(merchantConfig.getTimeout());
        sSLConfigurator.setKeystoreType(merchantConfig.getProperty("SSL_KEYSTORE_TYPE"));
        sSLConfigurator.setKeystoreAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        sSLConfigurator.setTruststorePath(merchantConfig.getProperty("SSL_TRUSTSTORE_FILE"));
        sSLConfigurator.setTruststorePass(merchantConfig.getProperty("SSL_TRUSTSTORE_PASSWORD"));
        sSLConfigurator.setTruststoreType(merchantConfig.getProperty("SSL_TRUSTSTORE_TYPE"));
        sSLConfigurator.setTruststoreAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        return sSLConfigurator;
    }

    private void bodyBase64Encode() throws MdkLocalException {
        String string = null;
        String string2 = this.context.getNameAndValues().toString();
        try {
            EncryptionUtils encryptionUtils = new EncryptionUtils();
            string = encryptionUtils.base64Enc(string2.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            throw new MdkLocalException("Error occurred while encode. " + this.getOriginalMessage(exception), "MA99", exception);
        }
        string = "3gpsBody=" + string;
        this.context.setNameAndValues(string);
    }

    public static String httpError(int n) {
        String string = null;
        switch (n) {
            case 500: {
                string = "MF05";
                break;
            }
            case 502: {
                string = "MF06";
                break;
            }
            case 503: {
                string = "MF07";
                break;
            }
            default: {
                string = "MF99";
            }
        }
        return string;
    }

    private MdkLocalException getSendException(Exception exception) {
        Throwable throwable = exception;
        String string = null;
        String string2 = null;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        this.logger.debug((Object)("========== Instance of exception is " + throwable.getClass().getName() + " =========="));
        if (throwable instanceof InterruptedIOException) {
            string = "Socket timeout. ";
            string2 = "MF03";
        } else if (throwable instanceof SocketException) {
            string = "Connect was not established. ";
            string2 = "MF02";
        } else if (throwable instanceof IOException) {
            string = "Key error or socket write/read error. ";
            string2 = "MF04";
        } else if (this.isSocketFactoryError(throwable)) {
            string = "SSLSocketFactory creation error has occurred. ";
            string2 = "MB03";
        } else if (throwable.getClass().getName().equals("javax.xml.ws.soap.SOAPFaultException")) {
            string = "Error occurred while encryption. " + this.getOriginalMessage(exception);
            string2 = "MA04";
        } else {
            string = "Error has occurred while sending or receiving message. ";
            string2 = "MF99";
        }
        return new MdkLocalException(string + this.getOriginalMessage(exception), string2, exception);
    }

    private boolean isSocketFactoryError(Throwable throwable) {
        return throwable instanceof KeyStoreException || throwable instanceof NoSuchAlgorithmException || throwable instanceof CertificateException || throwable instanceof FileNotFoundException || throwable instanceof KeyManagementException || throwable instanceof UnrecoverableKeyException;
    }

    private void setResponseXml(Object object) throws MdkLocalException {
        String string = null;
        try {
            string = MdkUtil.maskXml(this.response);
            Method method = object.getClass().getMethod(SET_RESULT_XML, String.class);
            method.invoke(object, string);
        }
        catch (Exception exception) {
            this.logger.error((Object)"!!!!!!!!!! Unable to set result xml to dto, wrong dto jar file. ");
            throw new MdkLocalException("Bad responseDto. " + this.getOriginalMessage(exception), "MA99", exception);
        }
        this.logger.debug((Object)("========== response xml     ==> " + MdkUtil.deleteRN(string)));
    }

    private void setResponseToDto(Object object, String string) throws MdkLocalException {
        try {
            MdkContentHandler mdkContentHandler = new MdkContentHandler(object);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(mdkContentHandler);
            StringReader stringReader = new StringReader(string);
            xMLReader.parse(new InputSource(stringReader));
        }
        catch (Exception exception) {
            this.logger.error((Object)"!!!!!!!!!! Error occurred while parsing xml !!!!!!!!!!");
            throw new MdkLocalException("Unable to convert xml to dto " + this.getOriginalMessage(exception), "MA99", exception);
        }
    }

    private Object errorProcess(Object object, Object object2, Exception exception) {
        Object object3 = null;
        if (object.toString() != null) {
            this.logger.error((Object)("!!!!!!!!!! Error request data is                      ==> " + object.toString() + " !!!!!!!!!!"));
        }
        if (object2 != null && object2.toString() != null) {
            this.logger.error((Object)("!!!!!!!!!! Error response data is                     ==> " + object2.toString() + " !!!!!!!!!!"));
        }
        this.logger.error((Object)"!!!!!!!!!! Stack Trace is below !!!!!!!!!!", (Throwable)exception);
        try {
            if (object2 != null) {
                this.setErrorDto(object2, exception);
            }
            object3 = object2;
        }
        catch (MdkLocalException mdkLocalException) {
            this.logger.error((Object)"!!!!!!!!!! Stack Trace is below !!!!!!!!!!", (Throwable)mdkLocalException);
            object3 = null;
        }
        return object3;
    }

    public void setErrorDto(Object object, Exception exception) throws MdkLocalException {
        Class<?> clazz = object.getClass();
        String string = "failure";
        String string2 = null;
        String string3 = null;
        if (exception instanceof MdkLocalException) {
            string2 = ((MdkLocalException)exception).getErrorCode() + VRESULT_RIGHT0;
            string3 = ((MdkLocalException)exception).getMerrMsg();
        } else {
            string2 = "MA99000000000000";
            string3 = MdkLocalException.convertErrorCode("MA99");
        }
        Class[] classArray = new Class[]{String.class};
        try {
            Method method = clazz.getMethod("setVResultCode", classArray);
            method.invoke(object, string2);
            method = clazz.getMethod("setMerrMsg", classArray);
            method.invoke(object, string3);
            method = clazz.getMethod("setMstatus", classArray);
            method.invoke(object, string);
        }
        catch (Exception exception2) {
            this.logger.error((Object)"!!!!!!!!!! fail to set error information to response dto. !!!!!!!!!!");
            throw new MdkLocalException("Response dto is broken. " + this.getOriginalMessage(exception2), "MB99", exception2);
        }
    }

    private String getOriginalMessage(Exception exception) {
        return exception.getMessage() != null ? exception.getMessage() : "";
    }
}

