/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk;

import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.veritrans.tercerog.mdk.context.MerchantSettingContext;
import jp.veritrans.tercerog.mdk.exception.MdkLocalException;
import org.apache.log4j.Logger;

public class MerchantConfig {
    public static final String BODY_ENCRYPT_SVR_ALIAS_NAME = "BODY_ENCRYPT_SVR_ALIAS_NAME";
    public static final String BODY_ENCRYPT_MDK_ALIAS_NAME = "BODY_ENCRYPT_MDK_ALIAS_NAME";
    protected static final String RESOURCE_FILE_NAME = "3GPSMDK";
    protected static final String RESOURCE_NAME = "3GPSMDK.properties";
    protected static final String DTO_RESOURCE_FILE_NAME = "dto";
    protected static final String DTO_RESOURCE_NAME = "dto.properties";
    protected static final String LOG4J_FILE_NAME = "log4j";
    protected static final String LOG4J_NAME = "log4j.properties";
    protected static final String POST_NO_SECURITY = "POST_NO_SECURITY";
    protected static final String HOST = "HOST_";
    protected static final String PROTOCOL = "PROTOCOL";
    public static final String SERVER_URL = "SERVER_URL";
    public static final String PROXY_URL = "PROXY_URL";
    public static final String PROXY_USER_ID = "PROXY_USER_ID";
    public static final String PROXY_USER_PW = "PROXY_USER_PW";
    public static final String MERCHANT_CC_ID = "MERCHANT_CCID";
    public static final String MERCHANT_SECRET_KEY = "MERCHANT_SECRET_KEY";
    public static final String SSL_TRUSTSTORE_FILE = "SSL_TRUSTSTORE_FILE";
    public static final String SSL_TRUSTSTORE_PASSWORD = "SSL_TRUSTSTORE_PASSWORD";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String DUMMY_REQUEST = "DUMMY_REQUEST";
    public static final String MDK_ERROR_MODE = "MDK_ERROR_MODE";
    public static final String MDK_VERSION = "MDK_VERSION";
    public static final String MDK_DTO_VERSION = "MDK_DTO_VERSION";
    protected static final String TXN_VERSION = "txnVersion";
    public static final String MDK_INTERNAL_PROPERTIES = "mdkinternal";
    public static final String SSL_TRUSTSTORE_TYPE = "SSL_TRUSTSTORE_TYPE";
    public static final String SSL_KEYSTORE_TYPE = "SSL_KEYSTORE_TYPE";
    public static final String TRUSTSTORE_TYPE = "TRUSTSTORE_TYPE";
    public static final String KEYSTORE_TYPE = "KEYSTORE_TYPE";
    public static final String COMMON_ITEM = "COMMON_ITEM";
    public static final String MASK_ITEM = "MASK_ITEM";
    public static final String TRIPARTITE_URL = "TRIPARTITE_URL";
    public static final String TRIPARTITE_SJIS_URL = "TRIPARTITE_SJIS_URL";
    private static final String ALLOW_HTTP = "ALLOW_HTTP";
    protected static final String MDK_ERROR_RETURN = "1";
    protected static final int NO_CONFIG = 1;
    protected static final int CONFIG_READ_ERROR = 2;
    protected static final int NO_INTERNAL_CONFIG = 3;
    protected static final int NO_LOG4J = 4;
    protected static final int NO_DTO_CONFIG = 5;
    protected static final Pattern URL_PATTERN = Pattern.compile("^https*://[^/]+:(\\d+)(/?|/.+/?)$");
    protected static final Pattern URL_PATTERN_SSL = Pattern.compile("^https://[^/:]+:\\d{2,5}/*.*$");
    protected static final Pattern URL_PATTERN_HTTP = Pattern.compile("^http[s]*://[^/:]+:\\d{2,5}/*.*$");
    protected static final String CONFIG_MISSING = "!!!!!!!!!! Property %s does not exist in config file. Add the property. !!!!!!!!!!";
    protected static final String VALUE_INVALID = "!!!!!!!!!! Property %s has invalid value \"%s\". Check the value. !!!!!!!!!!";
    public static final String FILE_NO_EXIST = "!!!!!!!!!! %s file does not exist at %s. Check the filename. !!!!!!!!!!";
    public static final String FILE_ALREADY_EXIST = "!!!!!!!!!! %s file already exist at %s. Check the file. !!!!!!!!!!";
    private int timeOut;
    private Properties properties;
    private ResourceBundle internalProperties = ResourceBundle.getBundle("mdkinternal");
    private Set exparamSet;
    private int configError = 0;
    private Logger logger = Logger.getLogger(this.getClass());

    public MerchantConfig() {
        this.properties = new Properties();
        try {
            String string;
            Object object;
            ResourceBundle resourceBundle;
            try {
                resourceBundle = ResourceBundle.getBundle(RESOURCE_FILE_NAME);
            }
            catch (Exception exception) {
                this.logger.error((Object)"!!!!!!!!!! Config file does not exist in the classpath !!!!!!!!!!");
                this.configError = 1;
                throw MdkLocalException.getFileNotExistException(RESOURCE_NAME, "classpath");
            }
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                this.properties.put(object, resourceBundle.getString((String)object));
            }
            try {
                object = ResourceBundle.getBundle(DTO_RESOURCE_FILE_NAME);
                this.properties.put(MDK_DTO_VERSION, ((ResourceBundle)object).getString(MDK_DTO_VERSION));
            }
            catch (Exception exception) {
                this.logger.error((Object)"!!!!!!!!!! Config file does not exist in the classpath !!!!!!!!!!");
                this.configError = 1;
                throw MdkLocalException.getFileNotExistException(DTO_RESOURCE_NAME, "classpath");
            }
            object = MerchantSettingContext.getContext();
            String string2 = ((MerchantSettingContext.Data)object).getMerchantCcid();
            String string3 = ((MerchantSettingContext.Data)object).getMerchantSecretKey();
            String string4 = ((MerchantSettingContext.Data)object).getTimeout();
            String string5 = ((MerchantSettingContext.Data)object).getDummyRequest();
            if (string2 != null) {
                this.properties.setProperty(MERCHANT_CC_ID, string2);
            }
            if (string3 != null) {
                this.properties.setProperty(MERCHANT_SECRET_KEY, string3);
            }
            if (string4 != null) {
                this.properties.setProperty(TIMEOUT, string4);
            }
            if (string5 != null) {
                this.properties.setProperty(DUMMY_REQUEST, string5);
            }
            try {
                ResourceBundle.getBundle(LOG4J_FILE_NAME);
            }
            catch (Exception exception) {
                this.logger.error((Object)"!!!!!!!!!! Config file does not exist in the classpath !!!!!!!!!!");
                this.configError = 4;
                throw MdkLocalException.getFileNotExistException(LOG4J_NAME, "classpath");
            }
            Enumeration<String> enumeration2 = this.internalProperties.getKeys();
            while (enumeration2.hasMoreElements()) {
                string = enumeration2.nextElement();
                this.properties.put(string, this.internalProperties.getString(string));
            }
            string = this.properties.getProperty(MDK_ERROR_MODE);
            if (!this.hasValue(string) || string.equals("0")) {
                this.properties.put(MDK_ERROR_MODE, "0");
            } else {
                this.properties.put(MDK_ERROR_MODE, MDK_ERROR_RETURN);
            }
        }
        catch (MdkLocalException mdkLocalException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.configError = 1;
        }
    }

    public void checkMerchantConfig() throws MdkLocalException {
        String string;
        String string2;
        Object object;
        switch (this.configError) {
            case 1: {
                this.logger.error((Object)"!!!!!!!!!! 3GPSMDK.properties does not exist in classpath !!!!!!!!!!");
                throw MdkLocalException.getFileNotExistException(RESOURCE_NAME, "classpath");
            }
            case 5: {
                this.logger.error((Object)"!!!!!!!!!! dto.properties does not exist in classpath !!!!!!!!!!");
                throw MdkLocalException.getFileNotExistException(DTO_RESOURCE_NAME, "classpath");
            }
            case 4: {
                throw MdkLocalException.getFileNotExistException(LOG4J_NAME, "classpath");
            }
        }
        String string3 = this.properties.getProperty(PROTOCOL);
        if (!this.hasValue(string3)) {
            this.logger.error((Object)CONFIG_MISSING.replaceFirst("%s", PROTOCOL));
            throw MdkLocalException.getMissingException(PROTOCOL);
        }
        if (!this.isProtocol(string3)) {
            this.logger.error((Object)VALUE_INVALID.replaceFirst("%s", PROTOCOL).replaceFirst("%s", string3));
            throw MdkLocalException.getInvalidValueException(PROTOCOL, string3);
        }
        String string4 = null;
        if (POST_NO_SECURITY.equals(string3)) {
            string4 = this.properties.getProperty("HOST_POST_NO_SECURITY");
            if (!this.hasValue(string4)) {
                this.logger.error((Object)CONFIG_MISSING.replaceFirst("%s", "HOST_POST_NO_SECURITY"));
                throw MdkLocalException.getMissingException("HOST_POST_NO_SECURITY");
            }
            object = URL_PATTERN_SSL;
            if ("true".equals(this.getProperty(ALLOW_HTTP))) {
                this.logger.debug((Object)"ALLOW HTTP Access");
                object = URL_PATTERN_HTTP;
            }
            if (!this.checkHostFormat(string4, (Pattern)object)) {
                this.logger.error((Object)VALUE_INVALID.replaceFirst("%s", "HOST_POST_NO_SECURITY").replaceFirst("%s", string4));
                throw MdkLocalException.getInvalidValueException("HOST_POST_NO_SECURITY", string4);
            }
        } else {
            throw MdkLocalException.getInvalidValueException(PROTOCOL, string3);
        }
        this.properties.put(SERVER_URL, this.properties.getProperty(HOST + string3));
        object = this.properties.getProperty(PROXY_URL);
        if (!this.hasValue((String)object)) {
            this.properties.setProperty(PROXY_URL, "");
        } else {
            if (!this.isURL((String)object, URL_PATTERN)) {
                this.logger.error((Object)VALUE_INVALID.replaceFirst("%s", PROXY_URL).replaceFirst("%s", (String)object));
                throw MdkLocalException.getInvalidValueException(PROXY_URL, (String)object);
            }
            if (!((String)object).endsWith("/")) {
                this.properties.setProperty(PROXY_URL, (String)object + "/");
            }
        }
        if (this.hasValue((String)object)) {
            string2 = this.properties.getProperty(PROXY_USER_ID);
            string = this.properties.getProperty(PROXY_USER_PW);
            if (!this.hasValue(string2) && this.hasValue(string)) {
                this.logger.error((Object)CONFIG_MISSING.replaceFirst("%s", PROXY_USER_ID));
                throw MdkLocalException.getMissingException(PROXY_USER_ID);
            }
            if (!this.hasValue(string)) {
                this.properties.put(PROXY_USER_PW, "");
            }
        }
        if (!this.hasValue(this.properties.getProperty(MERCHANT_CC_ID))) {
            this.logger.error((Object)CONFIG_MISSING.replaceFirst("%s", MERCHANT_CC_ID));
            throw MdkLocalException.getMissingException(MERCHANT_CC_ID);
        }
        if (!this.hasValue(this.properties.getProperty(MERCHANT_SECRET_KEY))) {
            this.logger.error((Object)CONFIG_MISSING.replaceFirst("%s", MERCHANT_SECRET_KEY));
            throw MdkLocalException.getMissingException(MERCHANT_SECRET_KEY);
        }
        string2 = this.properties.getProperty(SSL_TRUSTSTORE_FILE);
        if (!this.hasValue(string2)) {
            throw MdkLocalException.getMissingException(SSL_TRUSTSTORE_FILE);
        }
        if (!this.existFile(string2)) {
            this.logger.error((Object)FILE_NO_EXIST.replaceFirst("%s", SSL_TRUSTSTORE_FILE).replaceFirst("%s", string2));
            throw MdkLocalException.getFileNotExistException(SSL_TRUSTSTORE_FILE, string2);
        }
        if (!this.hasValue(this.properties.getProperty(SSL_TRUSTSTORE_PASSWORD))) {
            this.logger.error((Object)CONFIG_MISSING.replaceFirst("%s", SSL_TRUSTSTORE_PASSWORD));
            throw MdkLocalException.getMissingException(SSL_TRUSTSTORE_PASSWORD);
        }
        string = this.properties.getProperty(TIMEOUT);
        if (!this.hasValue(string)) {
            this.logger.error((Object)CONFIG_MISSING.replaceFirst("%s", TIMEOUT));
            throw MdkLocalException.getMissingException(TIMEOUT);
        }
        if (!this.isNumeric(string)) {
            this.logger.error((Object)VALUE_INVALID.replaceFirst("%s", TIMEOUT).replaceFirst("%s", string));
            throw MdkLocalException.getInvalidValueException(TIMEOUT, string);
        }
        this.timeOut = Integer.parseInt(string) * 1000;
        String string5 = this.properties.getProperty(DUMMY_REQUEST);
        if (!this.hasValue(string5)) {
            this.properties.put(DUMMY_REQUEST, "0");
        } else if (!"0".equals(string5) && !MDK_ERROR_RETURN.equals(string5)) {
            this.logger.error((Object)VALUE_INVALID.replaceFirst("%s", DUMMY_REQUEST).replaceFirst("%s", string5));
            throw MdkLocalException.getInvalidValueException(DUMMY_REQUEST, string5);
        }
        this.exparamSet = new HashSet();
        String string6 = this.properties.getProperty(COMMON_ITEM);
        StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.exparamSet.add(stringTokenizer.nextToken());
        }
    }

    private boolean hasValue(String string) {
        return string != null && string.length() != 0;
    }

    private boolean isProtocol(String string) {
        return POST_NO_SECURITY.equals(string);
    }

    private boolean checkHostFormat(String string, Pattern pattern) {
        return this.isURL(string, pattern);
    }

    private boolean existFile(String string) {
        File file = new File(string);
        return file.exists() && file.isFile();
    }

    private boolean isNumeric(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean isURL(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public int getTimeout() {
        return this.timeOut;
    }

    protected boolean throughProxy() {
        return this.properties.getProperty(PROXY_URL).length() != 0;
    }

    protected boolean isMdkErrorReturn() {
        return MDK_ERROR_RETURN.equals(this.getProperty(MDK_ERROR_MODE));
    }

    protected boolean addExparam(String string) {
        return !this.exparamSet.contains(string);
    }

    public String getUserAgent() {
        String string = this.properties.getProperty(MDK_VERSION);
        String string2 = this.properties.getProperty(MDK_DTO_VERSION);
        String string3 = System.getProperty("java.version");
        String string4 = System.getProperty("java.vendor");
        String string5 = this.properties.getProperty(PROTOCOL);
        return "VeriTrans 3GMDK/" + string + "/" + string2 + " (Java [" + string4 + "] " + string3 + "; " + string5 + ")";
    }
}

