/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.datetime;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;

public class FormatTag
extends BodyTagSupport {
    private boolean locale_flag = false;
    private String pattern = null;
    private String patternid = null;
    private String timeZone_string;
    private Date date = null;
    private String default_text = "Invalid Date";
    private String localeRef = null;
    private String symbolsRef = null;
    private DateFormatSymbols symbols = null;
    private Date output_date = null;

    public final int doStartTag() throws JspException {
        this.output_date = this.date;
        return 2;
    }

    public final int doAfterBody() throws JspException {
        BodyContent body = this.getBodyContent();
        String s = body.getString().trim();
        body.clearBody();
        if (this.output_date == null) {
            try {
                long time = Long.valueOf(s);
                this.output_date = new Date(time);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return 0;
    }

    public final int doEndTag() throws JspException {
        String date_formatted = this.default_text;
        if (this.output_date != null) {
            SimpleDateFormat sdf;
            Object attr;
            String pat = this.pattern;
            if (pat == null && this.patternid != null && (attr = ((TagSupport)this).pageContext.findAttribute(this.patternid)) != null) {
                pat = attr.toString();
            }
            if (pat == null) {
                sdf = new SimpleDateFormat();
                pat = sdf.toPattern();
            }
            if (this.symbolsRef != null) {
                this.symbols = (DateFormatSymbols)((TagSupport)this).pageContext.findAttribute(this.symbolsRef);
                if (this.symbols == null) {
                    throw new JspException("datetime format tag could not find dateFormatSymbols for symbolsRef \"" + this.symbolsRef + "\".");
                }
            }
            if (this.localeRef != null) {
                Locale locale = (Locale)((TagSupport)this).pageContext.findAttribute(this.localeRef);
                if (locale == null) {
                    throw new JspException("datetime format tag could not find locale for localeRef \"" + this.localeRef + "\".");
                }
                sdf = new SimpleDateFormat(pat, locale);
            } else {
                sdf = this.locale_flag ? new SimpleDateFormat(pat, ((TagSupport)this).pageContext.getRequest().getLocale()) : (this.symbols != null ? new SimpleDateFormat(pat, this.symbols) : new SimpleDateFormat(pat));
            }
            if (this.timeZone_string != null) {
                TimeZone timeZone = (TimeZone)((TagSupport)this).pageContext.getAttribute(this.timeZone_string, 3);
                if (timeZone == null) {
                    throw new JspTagException("Datetime format tag timeZone script variable \"" + this.timeZone_string + " \" does not exist");
                }
                sdf.setTimeZone(timeZone);
            }
            date_formatted = sdf.format(this.output_date);
        }
        try {
            ((TagSupport)this).pageContext.getOut().write(date_formatted);
        }
        catch (Exception e) {
            throw new JspException("IO Error: " + e.getMessage());
        }
        return 6;
    }

    public void release() {
        super.release();
        this.locale_flag = false;
        this.pattern = null;
        this.patternid = null;
        this.date = null;
        this.localeRef = null;
        this.symbolsRef = null;
        this.symbols = null;
    }

    public final void setLocale(boolean flag) {
        this.locale_flag = flag;
    }

    public final void setTimeZone(String tz) {
        this.timeZone_string = tz;
    }

    public final void setPattern(String str) {
        this.pattern = str;
    }

    public final void setPatternId(String str) {
        this.patternid = str;
    }

    public final void setDate(Date date) {
        this.date = date;
    }

    public final void setDefault(String default_text) {
        this.default_text = default_text;
    }

    public void setLocaleRef(String value) {
        this.localeRef = value;
    }

    public void setSymbolsRef(String symbolsRef) throws JspException {
        this.symbolsRef = symbolsRef;
    }
}

