/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.contrib.poibrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.poi.contrib.poibrowser.Codec;
import org.apache.poi.contrib.poibrowser.DocumentDescriptorRenderer;
import org.apache.poi.contrib.poibrowser.PropertySetDescriptor;
import org.apache.poi.contrib.poibrowser.Util;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.SummaryInformation;

public class PropertySetDescriptorRenderer
extends DocumentDescriptorRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        PropertySetDescriptor d = (PropertySetDescriptor)((DefaultMutableTreeNode)value).getUserObject();
        PropertySet ps = d.getPropertySet();
        JPanel p = new JPanel();
        JTextArea text = new JTextArea();
        text.setBackground(new Color(200, 255, 200));
        text.setFont(new Font("Monospaced", 0, 10));
        text.append(this.renderAsString(d));
        text.append("\nByte order: " + Codec.hexEncode((short)ps.getByteOrder()));
        text.append("\nFormat: " + Codec.hexEncode((short)ps.getFormat()));
        text.append("\nOS version: " + Codec.hexEncode(ps.getOSVersion()));
        text.append("\nClass ID: " + Codec.hexEncode(ps.getClassID()));
        text.append("\nSection count: " + ps.getSectionCount());
        text.append(this.sectionsToString(ps.getSections()));
        p.add(text);
        if (ps instanceof SummaryInformation) {
            SummaryInformation si = (SummaryInformation)ps;
            text.append("\n");
            text.append("\nTitle:               " + si.getTitle());
            text.append("\nSubject:             " + si.getSubject());
            text.append("\nAuthor:              " + si.getAuthor());
            text.append("\nKeywords:            " + si.getKeywords());
            text.append("\nComments:            " + si.getComments());
            text.append("\nTemplate:            " + si.getTemplate());
            text.append("\nLast Author:         " + si.getLastAuthor());
            text.append("\nRev. Number:         " + si.getRevNumber());
            text.append("\nEdit Time:           " + si.getEditTime());
            text.append("\nLast Printed:        " + si.getLastPrinted());
            text.append("\nCreate Date/Time:    " + si.getCreateDateTime());
            text.append("\nLast Save Date/Time: " + si.getLastSaveDateTime());
            text.append("\nPage Count:          " + si.getPageCount());
            text.append("\nWord Count:          " + si.getWordCount());
            text.append("\nChar Count:          " + si.getCharCount());
            text.append("\nApplication Name:    " + si.getApplicationName());
            text.append("\nSecurity:            " + si.getSecurity());
        }
        if (selected) {
            Util.invert(text);
        }
        return p;
    }

    protected String sectionsToString(List sections) {
        StringBuffer b = new StringBuffer();
        int count = 1;
        Iterator i = sections.iterator();
        while (i.hasNext()) {
            Section s = (Section)i.next();
            String d = this.toString(s, "Section " + count++);
            b.append(d);
        }
        return b.toString();
    }

    protected String toString(Section s, String name) {
        StringBuffer b = new StringBuffer();
        b.append("\n" + name + " Format ID: ");
        b.append(Codec.hexEncode(s.getFormatID()));
        b.append("\n" + name + " Offset: " + s.getOffset());
        b.append("\n" + name + " Section size: " + s.getSize());
        b.append("\n" + name + " Property count: " + s.getPropertyCount());
        Property[] properties = s.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            Property p = properties[i];
            Object value = p.getValue();
            b.append("\n" + name + " ");
            b.append("PID_");
            b.append(p.getID());
            b.append(' ');
            b.append(s.getPIDString(p.getID()) + ": ");
            if (value instanceof byte[]) {
                byte[] b2 = (byte[])value;
                b.append("0x" + Codec.hexEncode(b2, 0, 4));
                b.append(' ');
                b.append("0x" + Codec.hexEncode(b2, 4, b2.length - 4));
                continue;
            }
            if (value != null) {
                b.append(value.toString());
                continue;
            }
            b.append("null");
        }
        return b.toString();
    }
}

