/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.usermodel.HSSFFont;

public class HSSFCellStyle {
    private ExtendedFormatRecord format = null;
    private short index = 0;
    private short fontindex = 0;
    public static final short ALIGN_GENERAL = 0;
    public static final short ALIGN_LEFT = 1;
    public static final short ALIGN_CENTER = 2;
    public static final short ALIGN_RIGHT = 3;
    public static final short ALIGN_FILL = 4;
    public static final short ALIGN_JUSTIFY = 5;
    public static final short ALIGN_CENTER_SELECTION = 6;
    public static final short VERTICAL_TOP = 0;
    public static final short VERTICAL_CENTER = 1;
    public static final short VERTICAL_BOTTOM = 2;
    public static final short VERTICAL_JUSTIFY = 3;
    public static final short BORDER_NONE = 0;
    public static final short BORDER_THIN = 1;
    public static final short BORDER_MEDIUM = 2;
    public static final short BORDER_DASHED = 3;
    public static final short BORDER_HAIR = 4;
    public static final short BORDER_THICK = 5;
    public static final short BORDER_DOUBLE = 6;
    public static final short BORDER_DOTTED = 7;
    public static final short BORDER_MEDIUM_DASHED = 8;
    public static final short BORDER_DASH_DOT = 9;
    public static final short BORDER_MEDIUM_DASH_DOT = 10;
    public static final short BORDER_DASH_DOT_DOT = 11;
    public static final short BORDER_MEDIUM_DASH_DOT_DOT = 12;
    public static final short BORDER_SLANTED_DASH_DOT = 13;
    public static final short NO_FILL = 0;
    public static final short SOLID_FOREGROUND = 1;
    public static final short FINE_DOTS = 2;
    public static final short ALT_BARS = 3;
    public static final short SPARSE_DOTS = 4;
    public static final short THICK_HORZ_BANDS = 5;
    public static final short THICK_VERT_BANDS = 6;
    public static final short THICK_BACKWARD_DIAG = 7;
    public static final short THICK_FORWARD_DIAG = 8;
    public static final short BIG_SPOTS = 9;
    public static final short BRICKS = 10;
    public static final short THIN_HORZ_BANDS = 11;
    public static final short THIN_VERT_BANDS = 12;
    public static final short THIN_BACKWARD_DIAG = 13;
    public static final short THIN_FORWARD_DIAG = 14;
    public static final short SQUARES = 15;
    public static final short DIAMONDS = 16;
    public static final short LESS_DOTS = 17;
    public static final short LEAST_DOTS = 18;

    protected HSSFCellStyle(short index, ExtendedFormatRecord rec) {
        this.index = index;
        this.format = rec;
    }

    public short getIndex() {
        return this.index;
    }

    public void setDataFormat(short fmt) {
        this.format.setFormatIndex(fmt);
    }

    public short getDataFormat() {
        return this.format.getFormatIndex();
    }

    public void setFont(HSSFFont font) {
        this.format.setIndentNotParentFont(true);
        this.fontindex = font.getIndex();
        this.format.setFontIndex(this.fontindex);
    }

    public short getFontIndex() {
        return this.format.getFontIndex();
    }

    public void setHidden(boolean hidden) {
        this.format.setIndentNotParentCellOptions(true);
        this.format.setHidden(hidden);
    }

    public boolean getHidden() {
        return this.format.isHidden();
    }

    public void setLocked(boolean locked) {
        this.format.setIndentNotParentCellOptions(true);
        this.format.setLocked(locked);
    }

    public boolean getLocked() {
        return this.format.isLocked();
    }

    public void setAlignment(short align) {
        this.format.setIndentNotParentAlignment(true);
        this.format.setAlignment(align);
    }

    public short getAlignment() {
        return this.format.getAlignment();
    }

    public void setWrapText(boolean wrapped) {
        this.format.setIndentNotParentAlignment(true);
        this.format.setWrapText(wrapped);
    }

    public boolean getWrapText() {
        return this.format.getWrapText();
    }

    public void setVerticalAlignment(short align) {
        this.format.setVerticalAlignment(align);
    }

    public short getVerticalAlignment() {
        return this.format.getVerticalAlignment();
    }

    public void setRotation(short rotation) {
        if (rotation < 0 && rotation >= -90) {
            rotation = (short)(90 - rotation);
        } else if (rotation < -90 || rotation > 90) {
            throw new IllegalArgumentException("The rotation must be between -90 and 90 degrees");
        }
        this.format.setRotation(rotation);
    }

    public short getRotation() {
        short rotation = this.format.getRotation();
        if (rotation > 90) {
            rotation = (short)(90 - rotation);
        }
        return rotation;
    }

    public void setIndention(short indent) {
        this.format.setIndent(indent);
    }

    public short getIndention() {
        return this.format.getIndent();
    }

    public void setBorderLeft(short border) {
        this.format.setIndentNotParentBorder(true);
        this.format.setBorderLeft(border);
    }

    public short getBorderLeft() {
        return this.format.getBorderLeft();
    }

    public void setBorderRight(short border) {
        this.format.setIndentNotParentBorder(true);
        this.format.setBorderRight(border);
    }

    public short getBorderRight() {
        return this.format.getBorderRight();
    }

    public void setBorderTop(short border) {
        this.format.setIndentNotParentBorder(true);
        this.format.setBorderTop(border);
    }

    public short getBorderTop() {
        return this.format.getBorderTop();
    }

    public void setBorderBottom(short border) {
        this.format.setIndentNotParentBorder(true);
        this.format.setBorderBottom(border);
    }

    public short getBorderBottom() {
        return this.format.getBorderBottom();
    }

    public void setLeftBorderColor(short color) {
        this.format.setLeftBorderPaletteIdx(color);
    }

    public short getLeftBorderColor() {
        return this.format.getLeftBorderPaletteIdx();
    }

    public void setRightBorderColor(short color) {
        this.format.setRightBorderPaletteIdx(color);
    }

    public short getRightBorderColor() {
        return this.format.getRightBorderPaletteIdx();
    }

    public void setTopBorderColor(short color) {
        this.format.setTopBorderPaletteIdx(color);
    }

    public short getTopBorderColor() {
        return this.format.getTopBorderPaletteIdx();
    }

    public void setBottomBorderColor(short color) {
        this.format.setBottomBorderPaletteIdx(color);
    }

    public short getBottomBorderColor() {
        return this.format.getBottomBorderPaletteIdx();
    }

    public void setFillPattern(short fp) {
        this.format.setAdtlFillPattern(fp);
    }

    public short getFillPattern() {
        return this.format.getAdtlFillPattern();
    }

    public void setFillBackgroundColor(short bg) {
        this.format.setFillBackground(bg);
    }

    public short getFillBackgroundColor() {
        return this.format.getFillBackground();
    }

    public void setFillForegroundColor(short bg) {
        this.format.setFillForeground(bg);
    }

    public short getFillForegroundColor() {
        return this.format.getFillForeground();
    }
}

