/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.util;

import java.util.Arrays;
import java.util.Comparator;
import jp.livewell.baby.util.HanZenTable;

public class ZenHanConverter {
    public static final int ZENKANA_FIRST = 12449;
    public static final int ZENKANA_LAST = 12534;

    public String convert(String val) {
        if (val == null) {
            return null;
        }
        return this._convert(val, 0, val.length());
    }

    protected boolean isZenkaku(char chr) {
        return '\u30a1' <= chr && chr <= '\u30f6';
    }

    private int _putChars(char[] main, int mainPos, char[] parts) {
        int pos = mainPos;
        int i = 0;
        while (i < parts.length) {
            if (parts[i] != '\u0000') {
                main[pos++] = parts[i];
            }
            ++i;
        }
        return pos - mainPos;
    }

    private String _convert(String val, int pos, int length) {
        char[][][] table = HanZenTable.ZENHAN_TABLE;
        Comparator comp = HanZenTable.ZENHAN_COMPARATOR;
        int retIdx = 0;
        int maxPos = pos + length;
        char[] base = new char[1];
        char[] nChars = val.toCharArray();
        char[] nRets = new char[length * 2];
        while (pos < maxPos) {
            char currChar;
            if (!this.isZenkaku(currChar = nChars[pos++])) {
                nRets[retIdx++] = currChar;
                continue;
            }
            base[0] = currChar;
            char[] res = this._convertPart(base, table, comp);
            retIdx += this._putChars(nRets, retIdx, res);
        }
        return new String(nRets, 0, retIdx);
    }

    private char[] _convertPart(char[] chars, char[][][] sourceTable, Comparator comparator) {
        int index = Arrays.binarySearch((Object[])sourceTable, chars, comparator);
        if (index >= 0) {
            return sourceTable[index][0];
        }
        return chars;
    }
}

