/*
 * Decompiled with CFR 0.152.
 */
package jp.livewell.baby.util;

import java.util.Arrays;
import java.util.Comparator;

public class HanZenTable {
    public static final int IDX_HANKAKU = 0;
    public static final int IDX_ZENKAKU = 1;
    public static final int IDX_HAN_BASE = 0;
    public static final int IDX_HAN_DAKUON = 1;
    public static final Comparator HANZEN_COMPARATOR = new HankakuComparator();
    public static final Comparator ZENHAN_COMPARATOR = new ZenkakuComparator();
    protected static final char[][][] HANZEN_TABLE;
    protected static final char[][][] ZENHAN_TABLE;

    private HanZenTable() {
    }

    static {
        char[][][] table = new char[][][]{new char[][]{{'\uff61'}, {'\u3002'}}, new char[][]{{'\uff62'}, {'\u300c'}}, new char[][]{{'\uff63'}, {'\u300d'}}, new char[][]{{'\uff64'}, {'\u3001'}}, new char[][]{{'\uff65'}, {'\u30fb'}}, new char[][]{{'\uff66'}, {'\u30f2'}}, new char[][]{{'\uff67'}, {'\u30a1'}}, new char[][]{{'\uff68'}, {'\u30a3'}}, new char[][]{{'\uff69'}, {'\u30a5'}}, new char[][]{{'\uff6a'}, {'\u30a7'}}, new char[][]{{'\uff6b'}, {'\u30a9'}}, new char[][]{{'\uff6c'}, {'\u30e3'}}, new char[][]{{'\uff6d'}, {'\u30e5'}}, new char[][]{{'\uff6e'}, {'\u30e7'}}, new char[][]{{'\uff6f'}, {'\u30c3'}}, new char[][]{{'\uff70'}, {'\u30fc'}}, new char[][]{{'\uff71'}, {'\u30a2'}}, new char[][]{{'\uff72'}, {'\u30a4'}}, new char[][]{{'\uff73'}, {'\u30a6'}}, new char[][]{{'\uff73', '\uff9e'}, {'\u30f4'}}, new char[][]{{'\uff74'}, {'\u30a8'}}, new char[][]{{'\uff75'}, {'\u30aa'}}, new char[][]{{'\uff76'}, {'\u30ab'}}, new char[][]{{'\uff76', '\uff9e'}, {'\u30ac'}}, new char[][]{{'\uff77'}, {'\u30ad'}}, new char[][]{{'\uff77', '\uff9e'}, {'\u30ae'}}, new char[][]{{'\uff78'}, {'\u30af'}}, new char[][]{{'\uff78', '\uff9e'}, {'\u30b0'}}, new char[][]{{'\uff79'}, {'\u30b1'}}, new char[][]{{'\uff79', '\uff9e'}, {'\u30b2'}}, new char[][]{{'\uff7a'}, {'\u30b3'}}, new char[][]{{'\uff7a', '\uff9e'}, {'\u30b4'}}, new char[][]{{'\uff7b'}, {'\u30b5'}}, new char[][]{{'\uff7b', '\uff9e'}, {'\u30b6'}}, new char[][]{{'\uff7c'}, {'\u30b7'}}, new char[][]{{'\uff7c', '\uff9e'}, {'\u30b8'}}, new char[][]{{'\uff7d'}, {'\u30b9'}}, new char[][]{{'\uff7d', '\uff9e'}, {'\u30ba'}}, new char[][]{{'\uff7e'}, {'\u30bb'}}, new char[][]{{'\uff7e', '\uff9e'}, {'\u30bc'}}, new char[][]{{'\uff7f'}, {'\u30bd'}}, new char[][]{{'\uff7f', '\uff9e'}, {'\u30be'}}, new char[][]{{'\uff80'}, {'\u30bf'}}, new char[][]{{'\uff80', '\uff9e'}, {'\u30c0'}}, new char[][]{{'\uff81'}, {'\u30c1'}}, new char[][]{{'\uff81', '\uff9e'}, {'\u30c2'}}, new char[][]{{'\uff82'}, {'\u30c4'}}, new char[][]{{'\uff82', '\uff9e'}, {'\u30c5'}}, new char[][]{{'\uff83'}, {'\u30c6'}}, new char[][]{{'\uff83', '\uff9e'}, {'\u30c7'}}, new char[][]{{'\uff84'}, {'\u30c8'}}, new char[][]{{'\uff84', '\uff9e'}, {'\u30c9'}}, new char[][]{{'\uff85'}, {'\u30ca'}}, new char[][]{{'\uff86'}, {'\u30cb'}}, new char[][]{{'\uff87'}, {'\u30cc'}}, new char[][]{{'\uff88'}, {'\u30cd'}}, new char[][]{{'\uff89'}, {'\u30ce'}}, new char[][]{{'\uff8a'}, {'\u30cf'}}, new char[][]{{'\uff8a', '\uff9e'}, {'\u30d0'}}, new char[][]{{'\uff8a', '\uff9f'}, {'\u30d1'}}, new char[][]{{'\uff8b'}, {'\u30d2'}}, new char[][]{{'\uff8b', '\uff9e'}, {'\u30d3'}}, new char[][]{{'\uff8b', '\uff9f'}, {'\u30d4'}}, new char[][]{{'\uff8c'}, {'\u30d5'}}, new char[][]{{'\uff8c', '\uff9e'}, {'\u30d6'}}, new char[][]{{'\uff8c', '\uff9f'}, {'\u30d7'}}, new char[][]{{'\uff8d'}, {'\u30d8'}}, new char[][]{{'\uff8d', '\uff9e'}, {'\u30d9'}}, new char[][]{{'\uff8d', '\uff9f'}, {'\u30da'}}, new char[][]{{'\uff8e'}, {'\u30db'}}, new char[][]{{'\uff8e', '\uff9e'}, {'\u30dc'}}, new char[][]{{'\uff8e', '\uff9f'}, {'\u30dd'}}, new char[][]{{'\uff8f'}, {'\u30de'}}, new char[][]{{'\uff90'}, {'\u30df'}}, new char[][]{{'\uff91'}, {'\u30e0'}}, new char[][]{{'\uff92'}, {'\u30e1'}}, new char[][]{{'\uff93'}, {'\u30e2'}}, new char[][]{{'\uff94'}, {'\u30e4'}}, new char[][]{{'\uff95'}, {'\u30e6'}}, new char[][]{{'\uff96'}, {'\u30e8'}}, new char[][]{{'\uff97'}, {'\u30e9'}}, new char[][]{{'\uff98'}, {'\u30ea'}}, new char[][]{{'\uff99'}, {'\u30eb'}}, new char[][]{{'\uff9a'}, {'\u30ec'}}, new char[][]{{'\uff9b'}, {'\u30ed'}}, new char[][]{{'\uff9c'}, {'\u30ef'}}, new char[][]{{'\uff9d'}, {'\u30f3'}}, new char[][]{{'\uff9e'}, {'\u309b'}}, new char[][]{{'\uff9f'}, {'\u309c'}}};
        char[][][] hanzen = (char[][][])table.clone();
        Arrays.sort((Object[])hanzen, HANZEN_COMPARATOR);
        HANZEN_TABLE = hanzen;
        char[][][] zenAdd = new char[][][]{new char[][]{{'\uff72'}, {'\u30f0'}}, new char[][]{{'\uff74'}, {'\u30f1'}}, new char[][]{{'\uff76'}, {'\u30f5'}}, new char[][]{{'\uff79'}, {'\u30f6'}}};
        char[][][] zenhan = new char[table.length + zenAdd.length][][];
        System.arraycopy(table, 0, zenhan, 0, table.length);
        System.arraycopy(zenAdd, 0, zenhan, table.length, zenAdd.length);
        Arrays.sort((Object[])zenhan, ZENHAN_COMPARATOR);
        ZENHAN_TABLE = zenhan;
    }

    private static class ZenkakuComparator
    extends BaseComparator {
        ZenkakuComparator() {
        }

        protected char[] getCharArray(Object o) {
            if (o instanceof char[][]) {
                return ((char[][])o)[1];
            }
            return (char[])o;
        }
    }

    private static class HankakuComparator
    extends BaseComparator {
        HankakuComparator() {
        }

        protected char[] getCharArray(Object o) {
            if (o instanceof char[][]) {
                return ((char[][])o)[0];
            }
            return (char[])o;
        }
    }

    private static abstract class BaseComparator
    implements Comparator {
        BaseComparator() {
        }

        public int compare(Object x, Object y) {
            return this.compare(this.getCharArray(x), this.getCharArray(y));
        }

        public final int compare(char[] xChars, char[] yChars) {
            int xLen = xChars.length;
            int yLen = yChars.length;
            int max = xLen < yLen ? xLen : yLen;
            int ret = 0;
            int i = 0;
            while (i < max) {
                ret = xChars[i] - yChars[i];
                if (ret != 0) {
                    return ret;
                }
                ++i;
            }
            return xLen - yLen;
        }

        protected abstract char[] getCharArray(Object var1);
    }
}

