/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.CVS.GWLib;

import Jp.BuySmart.CVS.GWLib.ActionResource;
import Jp.BuySmart.CVS.GWLib.CVSException;
import Jp.BuySmart.CVS.GWLib.CVSLogger;
import Jp.BuySmart.CVS.GWLib.ComServer;
import Jp.BuySmart.CVS.GWLib.Crypto;
import Jp.BuySmart.CVS.GWLib.MessageResource;
import Jp.BuySmart.CVS.GWLib.RequestMessage;
import Jp.BuySmart.CVS.GWLib.ResponseMessage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Transaction {
    protected static final String ITEM_SEPARATOR = ",";
    public static final String CMD_ENTRY = "entry";
    public static final String ACCEPT_LANGUAGE_JA = "ja";
    public static final String ACCEPT_LANGUAGE_EN = "en";
    protected Logger logger = CVSLogger.getLogger();
    protected String sGWHostsRaw = null;
    protected String sHttpProxyHost = null;
    protected String sTrustedHostsRaw = null;
    protected int nTimeout = 120;
    protected boolean fUsePendingLogging = true;
    protected String sPendingDir = null;
    protected String sSecret = null;
    protected String sKeyHA1 = null;
    public static final String INIT_GW_HOSTS = "gw-hosts";
    public static final String INIT_HTTP_PROXY_HOST = "http-proxy-host";
    public static final String INIT_TRUSTED_HOSTS = "trusted-hosts";
    public static final String INIT_TIMEOUT = "timeout";
    public static final String INIT_USE_PENDING_LOGGING = "use-pending-logging";
    public static final String INIT_PENDING_DIR = "pending-dir";
    public static final String REQ_COMMAND = "command";
    public static final String REQ_SECRET = "secret";
    public static final String REQ_KEY_HA1 = "key-ha1";
    public static final String REQ_ACCEPT_LANGUAGE = "accept-language";
    public static final String REQ_ORDER_ID = "order-id";
    public static final String REQ_CVS_TYPE = "cvs-type";
    public static final String REQ_TXN_TYPE = "txn-type";
    public static final String REQ_AMOUNT = "amount";
    public static final String REQ_NAME1 = "name1";
    public static final String REQ_NAME2 = "name2";
    public static final String REQ_KANA = "kana";
    public static final String REQ_TEL_NO = "tel-no";
    public static final String REQ_PAY_LIMIT = "pay-limit";
    public static final String REQ_MAIL_ADDR = "mail-addr";
    public static final String REQ_PAYMENT_TYPE = "payment-type";
    public static final String REQ_FREE1 = "free1";
    public static final String REQ_FREE2 = "free2";
    public static final String REQ_DUMMY_TYPE = "dummy-type";
    public static final String REQ_ERR_CODE = "err-code";
    public static final String REQ_TXN_VERSION = "txn-version";
    public static final String RES_MSTATUS = "MStatus";
    public static final String RES_MSTATUS_SC = "success";
    public static final String RES_MSTATUS_FH = "failure-hard";
    public static final String RES_MSTATUS_FC = "failure-q-or-cancel";
    public static final String RES_MSTATUS_FD = "failure-q-or-discard";
    public static final String RES_MERRMSG = "MErrMsg";
    public static final String RES_MERRLOC = "MErrLoc";
    public static final String RES_MERRLOC_AT_MDK = "cvmdklib";
    public static final String RES_AUX_MSG = "aux-msg";
    public static final String RES_ACTION_CODE = "action-code";
    public static final String RES_TXN_VERSION = "txn-version";
    public static final String RES_ORDER_ID = "order-id";
    public static final String RES_ORDER_CTL_ID = "order-ctl-id";
    public static final String RES_MERCH_TXN = "merch-txn";
    public static final String RES_CUST_TXN = "cust-txn";
    public static final String RES_ERR_CODE = "err-code";
    public static final String RES_RECEIPT_NO = "receipt-no";
    public static final String RES_PAYMENT_TYPE = "payment-type";
    public static final String RES_HARAIKOMI_URL = "haraikomi-url";
    public static final String RES_REF_CODE = "ref-code";

    protected Transaction() {
    }

    public int getTimeout() {
        return this.nTimeout;
    }

    public void setTimeout(int n) {
        this.nTimeout = n;
    }

    public void setPendingDir(String string) {
        this.sPendingDir = string;
    }

    public String getPendingDir() {
        return this.sPendingDir;
    }

    public Map sendMServer(String string, Map map) {
        map.put(REQ_COMMAND, string);
        return this.doTransaction(map);
    }

    protected RequestMessage analyzeRequestMap(Map map) throws CVSException {
        Object object;
        Hashtable hashtable = new Hashtable();
        String string = "";
        String string2 = this.sSecret;
        String string3 = this.sKeyHA1;
        String string4 = "";
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (((String)object).equals(INIT_GW_HOSTS)) {
                this.sGWHostsRaw = (String)map.get(object);
                continue;
            }
            if (((String)object).equals(INIT_HTTP_PROXY_HOST)) {
                this.sHttpProxyHost = (String)map.get(object);
                continue;
            }
            if (((String)object).equals(INIT_TIMEOUT)) {
                try {
                    this.nTimeout = Integer.parseInt((String)map.get(object));
                    continue;
                }
                catch (Exception exception) {
                    throw new CVSException(INIT_TIMEOUT, exception);
                }
            }
            if (((String)object).equals(INIT_TRUSTED_HOSTS)) {
                this.sTrustedHostsRaw = (String)map.get(object);
                continue;
            }
            if (((String)object).equals(INIT_USE_PENDING_LOGGING)) {
                this.setUsePendingLogging((String)map.get(object));
                continue;
            }
            if (((String)object).equals(INIT_PENDING_DIR)) {
                this.sPendingDir = (String)map.get(object);
                continue;
            }
            if (((String)object).equals(REQ_COMMAND)) {
                string = (String)map.get(object);
                continue;
            }
            if (((String)object).equals(REQ_SECRET)) {
                string2 = (String)map.get(object);
                continue;
            }
            if (((String)object).equals(REQ_KEY_HA1)) {
                string3 = (String)map.get(object);
                continue;
            }
            if (((String)object).equals(REQ_ACCEPT_LANGUAGE)) {
                string4 = (String)map.get(object);
                continue;
            }
            hashtable.put(object, map.get(object));
        }
        object = new RequestMessage(string, string2, string3, string4, hashtable);
        return object;
    }

    public Map doTransaction(Map map) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        block25: {
            Object object4;
            String string;
            Object object5;
            this.logger.info((Object)"== Entering doTransaction ==");
            this.logger.debug((Object)"request:");
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object5 = (String)iterator.next();
                object3 = (String)map.get(object5);
                if (!((String)object5).equals(REQ_TEL_NO) && !((String)object5).equals(REQ_MAIL_ADDR)) {
                    if (object3 == null) continue;
                    this.logger.debug((Object)("    " + (String)object5 + ": " + (String)object3));
                    continue;
                }
                this.logger.debug((Object)("    " + (String)object5 + ": " + "****"));
            }
            object5 = null;
            object3 = null;
            try {
                object5 = this.analyzeRequestMap(map);
                string = ((RequestMessage)object5).getCommand();
                if (string == null || string.length() == 0) {
                    this.logger.info((Object)"== Exiting doTransaction ==");
                    return this.setLocalError(new CVSException("M01"), ((RequestMessage)object5).getFields());
                }
            }
            catch (CVSException cVSException) {
                object3 = this.setLocalError(cVSException, map);
                this.logger.warn((Object)"MStatus != success");
                iterator = object3.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    String string3 = (String)object3.get(string2);
                    this.logger.warn((Object)("    " + string2 + ": " + string3));
                }
                this.logger.info((Object)"== Exiting doTransaction ==");
                return object3;
            }
            this.logger.info((Object)"request:");
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                object4 = (String)map.get(string);
                if (!string.equals("order-id") && !string.equals(REQ_CVS_TYPE) && !string.equals(REQ_TXN_TYPE) && !string.equals(REQ_AMOUNT) || object4 == null) continue;
                this.logger.info((Object)("    " + string + ": " + (String)object4));
            }
            string = ((RequestMessage)object5).getCommand();
            object4 = ((RequestMessage)object5).getFields();
            try {
                if (this.getGWHostsVector().isEmpty()) {
                    throw new CVSException("M41", INIT_GW_HOSTS);
                }
                if (this.fUsePendingLogging) {
                    this.checkPendingDirectory();
                }
                object2 = Calendar.getInstance();
                object = this.getGWHostsVector();
                int n = ((Calendar)object2).get(13) % ((Vector)object).size();
                this.logger.debug((Object)"Connecting to Gateway...");
                ComServer comServer = new ComServer(this.sTrustedHostsRaw, this.nTimeout);
                String string4 = "";
                if (this.sHttpProxyHost != null && this.sHttpProxyHost.length() > 0) {
                    string4 = this.sHttpProxyHost;
                }
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    try {
                        String string5 = (String)((Vector)object).elementAt(n);
                        this.logger.debug((Object)("Connecting to Gateway: No." + (i + 1) + " " + string5));
                        comServer.start(string5, string4, (RequestMessage)object5);
                        break;
                    }
                    catch (CVSException cVSException) {
                        if (cVSException.getCode() != "M11" || i == ((Vector)object).size() - 1) {
                            throw cVSException;
                        }
                        if (n == ((Vector)object).size() - 1) {
                            n = 0;
                            continue;
                        }
                        ++n;
                        continue;
                    }
                }
                this.logger.debug((Object)("SendMServer: response = " + comServer.getResponseMessage()));
                object3 = ResponseMessage.getResponseInfo(comServer.getResponseMessage());
                if (object3.get(RES_MSTATUS).equals(RES_MSTATUS_FC) || object3.get(RES_MSTATUS).equals(RES_MSTATUS_FD)) {
                    this.pending((RequestMessage)object5);
                }
                this.replaseMessage((Map)object3);
            }
            catch (CVSException cVSException) {
                if (cVSException.getCode() == "M") break block25;
                try {
                    if (cVSException.getCode() == "M31") {
                        this.pending((RequestMessage)object5);
                    }
                    object3 = this.setLocalError(cVSException, (Map)object4);
                }
                catch (CVSException cVSException2) {
                    object3 = this.setLocalError(cVSException2, (Map)object4);
                }
            }
        }
        object2 = (String)object3.get(RES_MSTATUS);
        if (object2 != null && !((String)object2).equals(RES_MSTATUS_SC)) {
            this.logger.warn((Object)"MStatus != success");
            iterator = object3.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string = (String)object3.get(object);
                this.logger.warn((Object)("    " + (String)object + ": " + string));
            }
        } else {
            this.logger.info((Object)"MStatus = success");
            iterator = object3.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string = (String)object3.get(object);
                this.logger.info((Object)("    " + (String)object + ": " + string));
            }
        }
        this.logger.info((Object)"== Exiting doTransaction ==");
        return object3;
    }

    protected void checkPendingDirectory() throws CVSException {
        File file = new File(this.sPendingDir);
        if (!(file.isDirectory() && file.canWrite() && file.canRead())) {
            this.logger.error((Object)("!!Checking a pending directory is fail. : " + file.getName()));
            throw new CVSException("M44");
        }
    }

    protected String createPendingFilename() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
        return this.sPendingDir + "/" + simpleDateFormat.format(new Date()) + ".csv";
    }

    protected void pending(RequestMessage requestMessage) throws CVSException {
        Object object;
        this.logger.info((Object)"\t== Entering pending ==");
        this.logger.error((Object)"!!Pending had occured.");
        if (!this.fUsePendingLogging) {
            this.logger.debug((Object)"USE_PENDING_LOGGING == false, skip file logging.");
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
        String string = simpleDateFormat.format(new Date()) + ITEM_SEPARATOR;
        string = string + requestMessage.getSecret() + ITEM_SEPARATOR;
        string = string + requestMessage.getCommand();
        Map map = requestMessage.getFields();
        Iterator iterator = map.keySet().iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            int n;
            string = string + ITEM_SEPARATOR;
            string2 = (String)iterator.next();
            object = (String)map.get(string2);
            string = string + string2 + ITEM_SEPARATOR;
            if (string2.toLowerCase().equals(REQ_TEL_NO)) {
                object = "***-****-****";
            } else if (string2.toLowerCase().equals(REQ_MAIL_ADDR) && (n = ((String)object).indexOf(64)) > 0) {
                object = "****" + ((String)object).substring(n + 1);
            }
            string = string + (String)object;
        }
        try {
            object = new FileOutputStream(this.createPendingFilename(), true);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            throw new CVSException("M43");
        }
        finally {
            this.logger.info((Object)"\t== Exiting pending ==");
        }
    }

    protected Map replaseMessage(Map map) {
        String string = "err-code";
        String string2 = (String)map.get(string);
        if (string2 != null && string2.length() > 0) {
            ActionResource actionResource;
            String string3;
            MessageResource messageResource = MessageResource.getInstance();
            String string4 = messageResource.find(string2);
            if (string4 != null && !string4.equals("undefined messege.")) {
                map.put(RES_MERRMSG, string2 + ": " + string4);
                this.logger.debug((Object)("\treplaceMessage: msg = " + string4));
            }
            if ((string3 = (actionResource = ActionResource.getInstance()).find(string2)) != null && !string3.equals("-01")) {
                map.put(RES_ACTION_CODE, string3);
                this.logger.debug((Object)("\treplaceMessage: assign action-code: " + string3));
            }
        }
        return map;
    }

    protected Map setLocalError(CVSException cVSException, Map map) {
        this.logger.debug((Object)"== Entering setLocalError ==");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("txn-version", (String)map.get("txn-version"));
        if (cVSException.getCode() == "M31") {
            hashtable.put(RES_MSTATUS, RES_MSTATUS_FC);
        } else {
            hashtable.put(RES_MSTATUS, RES_MSTATUS_FH);
        }
        hashtable.put(RES_MERRLOC, RES_MERRLOC_AT_MDK);
        String string = cVSException.getCode();
        hashtable.put("err-code", string);
        MessageResource messageResource = MessageResource.getInstance();
        hashtable.put(RES_MERRMSG, messageResource.find(string, cVSException.getMessage()));
        ActionResource actionResource = ActionResource.getInstance();
        hashtable.put(RES_ACTION_CODE, actionResource.find(string));
        Enumeration enumeration = hashtable.keys();
        this.logger.debug((Object)"Set setLocalError() response:");
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            this.logger.debug((Object)("    " + string2 + ": " + string3));
        }
        this.logger.debug((Object)"== Exiting setLocalError ==");
        return hashtable;
    }

    public Vector getGWHostsVector() {
        if (this.sGWHostsRaw == null || this.sGWHostsRaw.length() == 0) {
            return new Vector();
        }
        String[] stringArray = this.sGWHostsRaw.split(ITEM_SEPARATOR);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i].trim());
            this.logger.debug((Object)("getGWHostsVector() i = " + i + ", host = " + stringArray[i]));
        }
        return vector;
    }

    public void setUsePendingLogging(String string) {
        if (string != null && string.length() > 0) {
            this.fUsePendingLogging = !string.toUpperCase().equals("FALSE");
        }
    }

    public void setKeyHA1(String string) {
        this.sKeyHA1 = string;
    }

    public void setSecret(String string) {
        this.sSecret = string;
    }

    public static String genHash(String string, String string2, String string3) {
        return Crypto.genHash(string, string2, string3);
    }
}

