/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.DddLib;

import Jp.BuySmart.DddLib.ActionResource;
import Jp.BuySmart.DddLib.Base.Crypto;
import Jp.BuySmart.DddLib.Base.DddException;
import Jp.BuySmart.DddLib.Base.Jdk13Helper;
import Jp.BuySmart.DddLib.Base.RequestMessage;
import Jp.BuySmart.DddLib.Base.RequestTags;
import Jp.BuySmart.DddLib.Base.ResponseMessage;
import Jp.BuySmart.DddLib.Base.ResponseTags;
import Jp.BuySmart.DddLib.ComServer;
import Jp.BuySmart.DddLib.JceResource;
import Jp.BuySmart.DddLib.LoggerFactory;
import Jp.BuySmart.DddLib.MessageResource;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Transaction
implements RequestTags,
ResponseTags {
    protected static final String ITEM_SEPARATOR = ",";
    public static final String INIT_GW_HOSTS = "gw-hosts";
    public static final String INIT_HTTP_PROXY_HOST = "http-proxy-host";
    public static final String INIT_TRUSTED_HOSTS = "trusted-hosts";
    public static final String INIT_TIMEOUT = "timeout";
    public static final String INIT_SSL_ALGORITHM = "ssl-algorithm";
    public static final String INIT_ACCEPT_LANGUAGE = "accept-language";
    public static final String INIT_SECRET = "secret";
    public static final String INIT_KEY_HA1 = "key-ha1";
    public static final String REQ_COMMAND = "command";
    public static final String CMD_AUTH = "auth";
    public static final String CMD_VERIFY = "verify";
    public static final String CMD_QUERY = "query";
    public static final String ACCEPT_LANGUAGE_JA = "ja";
    public static final String ACCEPT_LANGUAGE_EN = "en";
    public static final String MD_ENCODE_CHARSET = "UTF-8";
    public static final String MD_SEPARATOR = "&";
    public static final String MD_PAIR_SEPARATOR = "=";
    protected String gwHostsRaw = null;
    protected String httpProxyHost = null;
    protected String secret = null;
    protected String keyHA1 = null;
    protected int timeout = 120;
    protected String trustedHostsRaw = null;
    protected String acceptLanguage = "en";
    protected String sslAlgorithm = null;
    protected Logger logger = LoggerFactory.getLogger();

    protected Transaction() {
    }

    protected RequestMessage analyzeRequestMap(Map req) throws DddException {
        Hashtable newMap = new Hashtable();
        String command = "";
        Iterator it = req.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.equals(INIT_ACCEPT_LANGUAGE)) {
                this.acceptLanguage = (String)req.get(key);
                continue;
            }
            if (key.equals(INIT_GW_HOSTS)) {
                this.gwHostsRaw = (String)req.get(key);
                continue;
            }
            if (key.equals(INIT_HTTP_PROXY_HOST)) {
                this.httpProxyHost = (String)req.get(key);
                continue;
            }
            if (key.equals(INIT_KEY_HA1)) {
                this.keyHA1 = (String)req.get(key);
                continue;
            }
            if (key.equals(INIT_SECRET)) {
                this.secret = (String)req.get(key);
                continue;
            }
            if (key.equals(INIT_SSL_ALGORITHM)) {
                this.sslAlgorithm = (String)req.get(key);
                continue;
            }
            if (key.equals(INIT_TIMEOUT)) {
                try {
                    this.timeout = Integer.parseInt((String)req.get(key));
                    continue;
                }
                catch (Exception exp) {
                    throw new DddException(INIT_TIMEOUT, exp);
                }
            }
            if (key.equals(INIT_TRUSTED_HOSTS)) {
                this.trustedHostsRaw = (String)req.get(key);
                continue;
            }
            if (key.equals(REQ_COMMAND)) {
                command = (String)req.get(key);
                continue;
            }
            newMap.put(key, req.get(key));
        }
        String provider = JceResource.getInstance().find(this.sslAlgorithm);
        this.logger.debug((Object)("JCE Provider " + provider));
        RequestMessage reqMsg = new RequestMessage(command, this.secret, this.keyHA1, this.acceptLanguage, newMap, provider);
        return reqMsg;
    }

    public Map doTransaction(Map inParams) {
        String key;
        String command;
        this.logger.info((Object)"== Entering doTransaction ==");
        this.logger.debug((Object)"inParams:");
        Iterator itr = inParams.keySet().iterator();
        while (itr.hasNext()) {
            String key2 = (String)itr.next();
            String value = (String)inParams.get(key2);
            if (key2.equals("card-number")) {
                this.logger.debug((Object)(" *  " + key2 + ": " + RequestMessage.maskCardNumber(value)));
                continue;
            }
            this.logger.debug((Object)(" *  " + key2 + ": " + value));
        }
        RequestMessage reqMsg = null;
        Map response = null;
        try {
            reqMsg = this.analyzeRequestMap(inParams);
            command = reqMsg.getCommand();
            if (command == null || command.length() == 0) {
                this.logger.info((Object)"== Exiting doTransaction ==");
                return this.getResponseMap(new DddException("M80"), reqMsg.getFields());
            }
        }
        catch (DddException e) {
            response = this.getResponseMap(e, inParams);
            this.logger.warn((Object)"MStatus != success");
            itr = response.keySet().iterator();
            while (itr.hasNext()) {
                String key3 = (String)itr.next();
                String value = (String)response.get(key3);
                this.logger.warn((Object)(" *  " + key3 + ": " + value));
            }
            this.logger.info((Object)"== Exiting doTransaction ==");
            return response;
        }
        this.logger.info((Object)"request:");
        itr = inParams.keySet().iterator();
        while (itr.hasNext()) {
            String key4 = (String)itr.next();
            String value = (String)inParams.get(key4);
            if (!key4.equals("amount") && !key4.equals("txn-id") || value == null) continue;
            this.logger.info((Object)(" *  " + key4 + ": " + value));
        }
        command = reqMsg.getCommand();
        Map params = reqMsg.getFields();
        try {
            if (this.getGWHostsVector().isEmpty()) {
                throw new DddException("M93", INIT_GW_HOSTS);
            }
            Calendar calendar = Calendar.getInstance();
            Vector hosts = this.getGWHostsVector();
            int hostNo = calendar.get(13) % hosts.size();
            this.logger.debug((Object)"Connecting to Gateway...");
            ComServer cs = new ComServer(this.trustedHostsRaw, this.timeout, this.sslAlgorithm);
            String proxy = "";
            if (this.httpProxyHost != null && this.httpProxyHost.length() > 0) {
                proxy = this.httpProxyHost;
            }
            for (int i = 0; i < hosts.size(); ++i) {
                try {
                    String host = (String)hosts.elementAt(hostNo);
                    this.logger.debug((Object)("Connecting to Gateway: No." + (i + 1) + " " + host));
                    cs.start(host, proxy, reqMsg);
                    break;
                }
                catch (DddException exp) {
                    if (exp.getResultCode() != "M82" || i == hosts.size() - 1) {
                        throw exp;
                    }
                    if (hostNo == hosts.size() - 1) {
                        hostNo = 0;
                        continue;
                    }
                    ++hostNo;
                    continue;
                }
            }
            this.logger.debug((Object)("SendMServer: response = " + cs.getResponseMessage()));
            response = ResponseMessage.getFieldMap(cs.getResponseMessage());
            this.replaseMessage(response);
        }
        catch (DddException e) {
            response = this.getResponseMap(e, params);
        }
        String sMStat = (String)response.get("MStatus");
        if (sMStat != null && !sMStat.equals("success")) {
            this.logger.warn((Object)"MStatus != success");
            itr = response.keySet().iterator();
            while (itr.hasNext()) {
                key = (String)itr.next();
                String value = (String)response.get(key);
                this.logger.warn((Object)(" *  " + key + ": " + value));
            }
        } else {
            this.logger.info((Object)"MStatus = success");
            itr = response.keySet().iterator();
            while (itr.hasNext()) {
                key = (String)itr.next();
                String value = (String)response.get(key);
                this.logger.info((Object)(" *  " + key + ": " + value));
            }
        }
        this.logger.info((Object)"== Exiting doTransaction ==");
        return response;
    }

    protected Map replaseMessage(Map response) {
        String key = "err-code";
        String code = (String)response.get(key);
        if (code != null && code.length() > 0) {
            ActionResource resAct;
            String act;
            MessageResource resMsg = MessageResource.getInstance();
            String msg = resMsg.find(this.acceptLanguage, code);
            if (msg != null && !msg.equals("undefined messege.")) {
                response.put("MErrMsg", code + ": " + msg);
                this.logger.debug((Object)("\treplaceMessage: msg = " + msg));
            }
            if ((act = (resAct = ActionResource.getInstance()).find(code)) != null && !act.equals("-01")) {
                response.put("action-code", act);
                this.logger.debug((Object)("\treplaceMessage: assign action-code: " + act));
            }
        }
        return response;
    }

    protected Map getResponseMap(DddException e, Map reqInfo) {
        this.logger.debug((Object)"== Entering setLocalError ==");
        Hashtable<String, String> res_map = new Hashtable<String, String>();
        res_map.put("MStatus", "failure-hard");
        res_map.put("MErrLoc", "3dlib");
        String err_code = e.getResultCode();
        res_map.put("err-code", err_code);
        MessageResource msgRes = MessageResource.getInstance();
        res_map.put("MErrMsg", msgRes.find(this.acceptLanguage, err_code, e.getMessage()));
        ActionResource actRes = ActionResource.getInstance();
        res_map.put("action-code", actRes.find(err_code));
        Enumeration enumeration = res_map.keys();
        this.logger.debug((Object)"Set setLocalError() response:");
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)res_map.get(key);
            this.logger.debug((Object)(" *  " + key + ": " + value));
        }
        this.logger.debug((Object)"== Exiting setLocalError ==");
        if (e != null) {
            this.logger.error((Object)"Stack Trace of DddException class.", (Throwable)e);
        }
        return res_map;
    }

    protected Vector getGWHostsVector() {
        if (this.gwHostsRaw == null || this.gwHostsRaw.length() == 0) {
            return new Vector();
        }
        String[] hosts = Jdk13Helper.splitString(this.gwHostsRaw, ITEM_SEPARATOR);
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < hosts.length; ++i) {
            v.add(hosts[i].trim());
            this.logger.debug((Object)("getGWHostsVector() i = " + i + ", host = " + hosts[i]));
        }
        return v;
    }

    public static String genHash(String id, String key, String value) {
        return Crypto.genHash(id, key, value);
    }

    public String createMerchantData(Map map) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            sb.append(sep);
            String key = (String)it.next();
            sb.append(Jdk13Helper.encodeURLEnc(key, MD_ENCODE_CHARSET));
            sb.append(MD_PAIR_SEPARATOR);
            String value = (String)map.get(key);
            if (value != null && value.length() != 0) {
                sb.append(Jdk13Helper.encodeURLEnc(value, MD_ENCODE_CHARSET));
            }
            sep = MD_SEPARATOR;
        }
        String md = new String(sb);
        String hash = Crypto.genHash(this.secret, this.keyHA1, md);
        if (md.length() == 0) {
            md = hash;
        } else if (hash != null && hash.length() != 0) {
            md = hash + MD_SEPARATOR + md;
        }
        return md;
    }

    public Map analyzeMerchantData(String md) throws UnsupportedEncodingException {
        String now_hash;
        HashMap<String, String> map = new HashMap<String, String>();
        if (md == null || md.length() == 0) {
            return map;
        }
        int sep_index = md.indexOf(MD_SEPARATOR);
        if (sep_index < 0) {
            return map;
        }
        String md_hash = md.substring(0, sep_index);
        if (!md_hash.equals(now_hash = Crypto.genHash(this.secret, this.keyHA1, md = md.substring(sep_index + 1)))) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(md, MD_SEPARATOR);
        int cnt = st.countTokens();
        if (cnt < 1) {
            return map;
        }
        for (int i = 0; i < cnt; ++i) {
            StringTokenizer pair = new StringTokenizer(st.nextToken(), MD_PAIR_SEPARATOR);
            int nPairCnt = pair.countTokens();
            if (1 > nPairCnt) continue;
            String key = Jdk13Helper.decodeURLDec(pair.nextToken(), MD_ENCODE_CHARSET);
            String value = "";
            if (1 < nPairCnt) {
                value = Jdk13Helper.decodeURLDec(pair.nextToken(), MD_ENCODE_CHARSET);
            }
            map.put(key, value);
        }
        return map;
    }
}

