/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.DddLib;

import Jp.BuySmart.DddLib.Base.DddException;
import Jp.BuySmart.DddLib.Base.RequestMessage;
import Jp.BuySmart.DddLib.JsseResource;
import Jp.BuySmart.DddLib.LoggerFactory;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;

class ComServer {
    public static final String CERT_FILE = "jssecacerts";
    private final String VERSION = "1.0";
    protected final String CONTENT_LENGTH = "Content-Length";
    protected final int CL_TAG_LEN = "Content-Length".length();
    private final String KEYSTORE_PASSWD = "3DGWKEY";
    private int timeout = 0;
    private int code = -1;
    private String message = null;
    private Logger logger = LoggerFactory.getLogger();
    protected String sTrustedHosts = null;
    protected String sslAlgorithm = null;

    public URL getCertFileURL() {
        return this.getClass().getResource(CERT_FILE);
    }

    public ComServer(String sTrustedHosts, int timeout, String ssl_alg) {
        this.sTrustedHosts = sTrustedHosts;
        this.timeout = timeout;
        this.sslAlgorithm = ssl_alg;
    }

    public String getResponseMessage() {
        return this.message;
    }

    public int getResponseCode() {
        return this.code;
    }

    public void start(String host, String proxy, RequestMessage reqMsg) throws DddException {
        this.logger.info((Object)("=== SENDMSERVER to host=" + host + ", proxy=" + proxy + " ==="));
        try {
            if (!host.endsWith("/")) {
                host = host + "/";
            }
            boolean https_flag = this.checkProtocol(host);
            Hashtable parsed = this.parseUrl(host);
            if (https_flag) {
                this.useHttpsConnect((String)parsed.get("host"), Integer.parseInt((String)parsed.get("port")), proxy, reqMsg);
            } else {
                this.useHttpConnect((String)parsed.get("host"), Integer.parseInt((String)parsed.get("port")), proxy, reqMsg);
            }
            this.checkHttpStatusCode();
        }
        catch (DddException e) {
            if (e.getResultCode().equals("M84")) {
                this.logger.error((Object)"!!Connected timeout.", (Throwable)e);
            } else if (e.getResultCode().equals("M82")) {
                this.logger.error((Object)("!!Could not connect payment server: " + host + "."), (Throwable)e);
            } else if (e.getResultCode().equals("M82")) {
                this.logger.error((Object)("!!Could not connect proxy server: " + proxy + "."), (Throwable)e);
            } else if (e.getResultCode().equals("M81")) {
                this.logger.error((Object)"!!error writing  to socket.", (Throwable)e);
            } else if (e.getResultCode().equals("M95")) {
                this.logger.error((Object)"!!fail to calculate HMAC.", (Throwable)e);
            } else if (e.getResultCode().equals("M92")) {
                this.logger.error((Object)"!!bad response.", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e2) {
            this.logger.error((Object)("!!Could not connect payment server: " + host + "."));
            throw new DddException("M82", e2);
        }
    }

    private void checkHttpStatusCode() throws DddException {
        switch (this.code) {
            case 200: {
                break;
            }
            case 401: {
                throw new DddException("M85");
            }
            case 403: {
                throw new DddException("M86");
            }
            case 404: {
                throw new DddException("M87");
            }
            case 500: {
                throw new DddException("M88");
            }
            case 502: {
                throw new DddException("M89");
            }
            case 503: {
                throw new DddException("M90");
            }
            default: {
                throw new DddException("M91", String.valueOf(this.code));
            }
        }
    }

    private Hashtable parseUrl(String url) throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        int first = 0;
        int end = 0;
        first = url.indexOf("://");
        table.put("protocol", url.substring(0, first));
        end = url.indexOf(":", first + 3);
        table.put("host", url.substring(first + 3, end));
        first = end;
        end = url.indexOf("/", first);
        table.put("port", url.substring(first + 1, end));
        return table;
    }

    private boolean checkProtocol(String url) throws DddException {
        if (url.startsWith("https://")) {
            return true;
        }
        if (url.startsWith("http://")) {
            return false;
        }
        throw new DddException("M82");
    }

    private void checkCertificate(Socket socket) throws DddException {
        try {
            ((SSLSocket)socket).startHandshake();
            SSLSession session = ((SSLSocket)socket).getSession();
            X509Certificate[] x509 = session.getPeerCertificateChain();
            boolean check = false;
            String server = null;
            String invalid_server = "";
            for (int i = 0; i < x509.length; ++i) {
                String subject_dn = ((Object)x509[i].getSubjectDN()).toString();
                int first = subject_dn.indexOf("CN=");
                if (first == -1) continue;
                int end = subject_dn.indexOf(",", first += 3);
                server = end != -1 ? subject_dn.substring(first, end) : subject_dn.substring(first);
                this.logger.debug((Object)("SSL Trust Server = " + server));
                check = this.isTrustHost(server);
                if (check) break;
                invalid_server = server + " ";
            }
            if (!check) {
                this.logger.error((Object)("!!mismatch host name: " + invalid_server));
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new DddException("M82", e);
        }
    }

    private void doTunnelHandshake(Socket tunnel, String host, int port) throws DddException {
        DataOutputStream t_dos = null;
        try {
            t_dos = new DataOutputStream(tunnel.getOutputStream());
            t_dos.writeBytes("CONNECT " + host + ":" + port + " HTTP/1.0\r\n\r\n");
            t_dos.flush();
        }
        catch (IOException e2) {
            throw new DddException("M81", e2);
        }
        catch (Exception e3) {
            throw new DddException("M82", e3);
        }
        String status = "";
        BufferedReader t_br = null;
        try {
            t_br = new BufferedReader(new InputStreamReader(tunnel.getInputStream(), "8859_1"));
            status = t_br.readLine();
            String line = null;
            while (status != null && (line = t_br.readLine()) != null && line.length() != 0) {
            }
        }
        catch (IOException e2) {
            throw new DddException("M97", e2);
        }
        catch (Exception e) {
            throw new DddException("M82", e);
        }
        if (status == null || !status.startsWith("HTTP/1.0 200")) {
            throw new DddException("M82");
        }
    }

    private boolean isTrustHost(String host) {
        if (host == null) {
            return false;
        }
        String trust_hosts = this.sTrustedHosts;
        boolean trust = false;
        StringTokenizer e = new StringTokenizer(trust_hosts, ",");
        while (e.hasMoreElements()) {
            String h = (String)e.nextElement();
            if (!host.equals(h.trim())) continue;
            trust = true;
            break;
        }
        return trust;
    }

    private void receiveData(Socket socket) throws DddException {
        this.logger.info((Object)"== Reading payment server response ==");
        String header = "";
        StringBuffer body = new StringBuffer("");
        BufferedReader br = null;
        try {
            int idx;
            br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "8859_1"));
            String line = null;
            line = br.readLine();
            if (line != null) {
                idx = line.indexOf(" ");
                if (idx == -1) {
                    throw new DddException("M97");
                }
            } else {
                throw new DddException("M97");
            }
            String scode = line.substring(idx + 1, idx + 4);
            this.code = Integer.parseInt(scode);
            header = header + line;
            header = header + "\r\n";
            boolean bTrnsEncode = false;
            int ctLength = -1;
            while ((line = br.readLine()) != null && line.length() != 0) {
                if (line.compareToIgnoreCase("Transfer-Encoding: chunked") == 0) {
                    bTrnsEncode = true;
                }
                if (line.toLowerCase().startsWith("Content-Length".toLowerCase())) {
                    int idx2 = line.indexOf(":");
                    if (idx2 == -1) {
                        throw new DddException("M97");
                    }
                    String s = line.substring(idx2 + 2);
                    ctLength = Integer.parseInt(s, 10);
                }
                header = header + line;
                header = header + "\r\n";
            }
            header = header + "\r\n";
            if (bTrnsEncode) {
                while ((line = br.readLine()) != null) {
                    int chunk = Integer.parseInt(line, 16);
                    if (chunk == 0) {
                        line = br.readLine();
                        break;
                    }
                    char[] buff = new char[chunk];
                    int cur = 0;
                    int read = 0;
                    while (read < chunk) {
                        if (!br.ready()) continue;
                        cur = br.read(buff, 0, chunk - read);
                        if (cur == -1) break;
                        read += cur;
                        body.append(buff, 0, cur);
                    }
                    if (chunk != read) {
                        throw new Exception();
                    }
                    buff = null;
                    br.readLine();
                }
            } else if (ctLength > -1) {
                int read;
                char[] buff = new char[ctLength];
                int cur = 0;
                for (read = 0; read < ctLength && (cur = br.read(buff, 0, ctLength - read)) != -1; read += cur) {
                    body.append(buff, 0, cur);
                }
                if (ctLength != read) {
                    throw new Exception("Content-Length is a not equal readed size.");
                }
            } else {
                char[] buff = new char[4096];
                int cur = br.read(buff, 0, buff.length);
                while (cur > 0) {
                    body.append(buff, 0, cur);
                    cur = br.read(buff, 0, buff.length);
                    if (cur != 0) continue;
                    System.err.println("cur == 0!!!");
                }
            }
            int resLen = header.length() + body.length();
            this.logger.debug((Object)("recieve data(" + resLen + "):\n" + header + body.toString()));
            this.message = body.toString();
        }
        catch (DddException e0) {
            throw e0;
        }
        catch (InterruptedIOException e1) {
            throw new DddException("M84", e1);
        }
        catch (IOException e2) {
            throw new DddException("M97", e2);
        }
        catch (Exception e3) {
            throw new DddException("M92", e3);
        }
    }

    private void sendData(Socket socket, String sProtocolHostPort, RequestMessage reqMsg) throws DddException {
        String msg = sProtocolHostPort.length() == 0 ? reqMsg.getMessage() : reqMsg.getMessageForProxy(sProtocolHostPort);
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(socket.getOutputStream());
            this.logger.debug((Object)"Send request.");
            dos.writeBytes(msg);
            dos.flush();
        }
        catch (Exception e) {
            throw new DddException("M81", e);
        }
        this.logger.debug((Object)("Send data\n" + reqMsg.getMessageForLogging()));
    }

    private void useHttpConnect(String host, int port, String proxy, RequestMessage reqMsg) throws DddException {
        boolean proxy_flag = proxy != null && proxy.length() != 0;
        Socket socket = null;
        try {
            if (proxy_flag) {
                this.logger.debug((Object)("Use Proxy = " + proxy));
                URL obj = new URL("http://" + proxy);
                socket = new Socket(obj.getHost(), obj.getPort());
            } else {
                socket = new Socket(host, port);
            }
            socket.setSoTimeout(this.timeout * 1000);
        }
        catch (Exception e1) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (proxy_flag) {
                throw new DddException("M83", e1);
            }
            throw new DddException("M82", e1);
        }
        try {
            if (proxy_flag) {
                this.sendData(socket, "http://" + host + ":" + port, reqMsg);
            } else {
                this.sendData(socket, "", reqMsg);
            }
        }
        catch (DddException e0) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e0;
        }
        catch (Exception e1) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new DddException("M81", e1);
        }
        try {
            this.receiveData(socket);
        }
        catch (DddException e0) {
            throw e0;
        }
        catch (Exception e1) {
            throw new DddException("M97", e1);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e2) {}
        }
    }

    private void useHttpsConnect(String host, int port, String proxy, RequestMessage reqMsg) throws DddException {
        boolean proxy_flag = proxy != null && proxy.length() != 0;
        try {
            String name = JsseResource.getInstance().find(this.sslAlgorithm);
            this.logger.debug((Object)("JSSE Provider " + name));
            Security.addProvider((Provider)Class.forName(name).newInstance());
        }
        catch (Exception e) {
            this.logger.error((Object)"\tcan't append JSSE Provider.");
            throw new DddException("M82", e);
        }
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("JKS");
            URL cacert = this.getCertFileURL();
            ks.load(cacert.openStream(), "3DGWKEY".toCharArray());
        }
        catch (Exception e) {
            this.logger.error((Object)("!!fail to use a certificate file: " + this.getCertFileURL() + "!!"));
            if (proxy_flag) {
                throw new DddException("M83", e);
            }
            throw new DddException("M82", e);
        }
        SSLSocketFactory factory = null;
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.sslAlgorithm);
            tmf.init(ks);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            factory = ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e2) {
            this.logger.error((Object)"\tcan't create SSL Context");
            if (proxy_flag) {
                throw new DddException("M83", e2);
            }
            throw new DddException("M82", e2);
        }
        catch (Exception e3) {
            if (proxy_flag) {
                throw new DddException("M83", e3);
            }
            throw new DddException("M82", e3);
        }
        Socket tunnel = null;
        Socket socket = null;
        try {
            if (proxy_flag) {
                this.logger.debug((Object)("Use Proxy = " + proxy));
                URL obj = new URL("http://" + proxy);
                tunnel = new Socket(obj.getHost(), obj.getPort());
                tunnel.setSoTimeout(this.timeout * 1000);
                this.doTunnelHandshake(tunnel, host, port);
                socket = (SSLSocket)factory.createSocket(tunnel, host, port, true);
            } else {
                socket = (SSLSocket)factory.createSocket(host, port);
            }
            socket.setSoTimeout(this.timeout * 1000);
            this.checkCertificate(socket);
        }
        catch (DddException e0) {
            try {
                if (socket != null) {
                    socket.close();
                }
                if (tunnel != null) {
                    tunnel.close();
                }
            }
            catch (Exception e5) {
                // empty catch block
            }
            throw e0;
        }
        catch (Exception e3) {
            try {
                if (socket != null) {
                    socket.close();
                }
                if (tunnel != null) {
                    tunnel.close();
                }
            }
            catch (Exception e5) {
                // empty catch block
            }
            if (proxy_flag) {
                throw new DddException("M83", e3);
            }
            throw new DddException("M82", e3);
        }
        try {
            if (proxy != null && proxy.length() != 0) {
                this.sendData(socket, "https://" + host + ":" + port, reqMsg);
            } else {
                this.sendData(socket, "", reqMsg);
            }
        }
        catch (DddException e0) {
            try {
                if (socket != null) {
                    socket.close();
                }
                if (tunnel != null) {
                    tunnel.close();
                }
            }
            catch (Exception e5) {
                // empty catch block
            }
            throw e0;
        }
        catch (Exception e1) {
            try {
                if (socket != null) {
                    socket.close();
                }
                if (tunnel != null) {
                    tunnel.close();
                }
            }
            catch (Exception e5) {
                // empty catch block
            }
            throw new DddException("M81", e1);
        }
        try {
            this.receiveData(socket);
        }
        catch (DddException e0) {
            throw e0;
        }
        catch (Exception e1) {
            throw new DddException("M97", e1);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
                if (tunnel != null) {
                    tunnel.close();
                }
            }
            catch (Exception e5) {}
        }
    }
}

