/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.DddLib.Base;

import Jp.BuySmart.DddLib.Base.BaseMessage;
import Jp.BuySmart.DddLib.Base.Crypto;
import Jp.BuySmart.DddLib.Base.DddException;
import Jp.BuySmart.DddLib.Base.RequestFixedValues;
import Jp.BuySmart.DddLib.Base.RequestTags;
import java.util.Map;

public class RequestMessage
extends BaseMessage
implements RequestFixedValues,
RequestTags {
    protected static final String HMAC_ALGORITHM = "HmacSHA1";
    protected String command = null;
    protected String secret = null;
    protected String keyHA1 = null;
    protected String acceptLanguage = null;
    protected String provider = null;

    public RequestMessage(String cmd, String sec, String key, String lang, Map info, String prov) {
        super(info);
        this.command = cmd;
        this.secret = sec;
        this.keyHA1 = key;
        this.acceptLanguage = lang;
        this.provider = prov;
    }

    public RequestMessage(String cmd, String lang, String msg_body) throws DddException {
        super(RequestMessage.getFieldMap(msg_body));
        this.command = cmd;
        this.secret = "";
        this.keyHA1 = "";
        this.acceptLanguage = lang;
        this.provider = "";
    }

    public String getMessageForProxy(String sProtocolHostPort) throws DddException {
        String sBody = this.getMessageBody();
        String sHeader = this.getMessageHeader(sBody);
        String sStartLine = this.getMessageStartLineForProxy(sProtocolHostPort);
        return sStartLine + sHeader + sBody;
    }

    public String getPath() {
        if (System.getProperty("Jp.BuySmart.DddLib.directPath") == null) {
            return "/3dgw/" + this.secret + "/" + this.command;
        }
        return "/3dgw/" + this.command + "/" + this.secret;
    }

    protected String getMessageStartLine() {
        return "POST " + this.getPath() + " HTTP/1.0\r\n";
    }

    protected String getMessageStartLineForProxy(String sProtocolHostPort) {
        if (sProtocolHostPort == null) {
            return this.getMessageStartLine();
        }
        if (sProtocolHostPort.length() == 0) {
            return this.getMessageStartLine();
        }
        String sPath = sProtocolHostPort.endsWith("/") ? sProtocolHostPort + this.getPath().substring(1) : sProtocolHostPort + this.getPath();
        return "POST " + sPath + " HTTP/1.0\r\n";
    }

    protected String getMessageHeader(String body) throws DddException {
        String hmac = Crypto.hmac(this.provider, HMAC_ALGORITHM, this.keyHA1, body);
        return "User-Agent: 3DLib/1.0.0(Java)\r\nContent-type: application/x-www-form-urlencoded\r\nContent-length: " + body.length() + "\r\n" + "Content-HMAC" + ": h=" + "HMAC-SHA1-160" + "; s=" + this.secret + "; v=" + hmac + "\r\n" + "Accept-Language" + ": " + this.acceptLanguage + "\r\n" + "\r\n";
    }

    public String getCommand() {
        return this.command;
    }

    public Map getFields() {
        return this.fields;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getKeyHA1() {
        return this.keyHA1;
    }

    public String maskPrivateField(String name, String value) {
        if (name.equalsIgnoreCase("card-number")) {
            value = RequestMessage.maskCardNumber(value);
        }
        return value;
    }
}

