/*
 * Decompiled with CFR 0.152.
 */
package Jp.BuySmart.DddLib.Base;

import Jp.BuySmart.DddLib.Base.DddException;
import Jp.BuySmart.DddLib.Base.Jdk13Helper;
import Jp.BuySmart.DddLib.Base.ResultCode;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class BaseMessage
implements ResultCode {
    protected static final String ENCODE_CHARSET = "UTF-8";
    protected Map fields = null;

    protected BaseMessage(Map map) {
        this.fields = map;
    }

    public static Map getFieldMap(String sBody) throws DddException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        try {
            StringTokenizer st = new StringTokenizer(sBody, "&");
            int nCnt = st.countTokens();
            if (nCnt < 1) {
                return params;
            }
            for (int i = 0; i < nCnt; ++i) {
                StringTokenizer pair = new StringTokenizer(st.nextToken(), "=");
                int nPairCnt = pair.countTokens();
                if (1 > nPairCnt) {
                    return params;
                }
                String key = Jdk13Helper.decodeURLDec(pair.nextToken(), ENCODE_CHARSET);
                String value = "";
                if (1 < nPairCnt) {
                    value = Jdk13Helper.decodeURLDec(pair.nextToken(), ENCODE_CHARSET);
                }
                params.put(key, value);
            }
        }
        catch (UnsupportedEncodingException exp) {
            throw new DddException("M96", exp);
        }
        return params;
    }

    public String getMessage() throws DddException {
        String sBody = this.getMessageBody();
        String sHeader = this.getMessageHeader(sBody);
        String sStartLine = this.getMessageStartLine();
        return sStartLine + sHeader + sBody;
    }

    public String getMessageForLogging() throws DddException {
        String sBody = this.getMessageBodyForLogging();
        String sHeader = this.getMessageHeader(sBody);
        String sStartLine = this.getMessageStartLine();
        return sStartLine + sHeader + sBody;
    }

    protected abstract String getMessageStartLine() throws DddException;

    protected abstract String getMessageHeader(String var1) throws DddException;

    public String getMessageBody() throws DddException {
        String sBody = "";
        try {
            String sSeparator = "";
            Iterator it = this.fields.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)this.fields.get(key);
                if (value == null) {
                    value = "";
                }
                sBody = sBody + sSeparator + Jdk13Helper.encodeURLEnc(key, ENCODE_CHARSET) + "=" + Jdk13Helper.encodeURLEnc(value, ENCODE_CHARSET);
                sSeparator = "&";
            }
        }
        catch (UnsupportedEncodingException exp) {
            throw new DddException("M96", exp);
        }
        return sBody;
    }

    public String getMessageBodyForLogging() throws DddException {
        String sBody = "";
        try {
            String sSeparator = "";
            Iterator it = this.fields.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)this.fields.get(key);
                if (value == null) {
                    value = "";
                }
                String masked = this.maskPrivateField(key, value);
                sBody = sBody + sSeparator + Jdk13Helper.encodeURLEnc(key, ENCODE_CHARSET) + "=" + Jdk13Helper.encodeURLEnc(masked, ENCODE_CHARSET);
                sSeparator = "&";
            }
        }
        catch (UnsupportedEncodingException exp) {
            throw new DddException("M96", exp);
        }
        return sBody;
    }

    public abstract String maskPrivateField(String var1, String var2);

    public static String maskCardNumber(String value) {
        if (value == null || value.length() == 0) {
            value = "";
        } else if (value.length() >= 3) {
            StringBuffer sb = new StringBuffer(value);
            int max = 12;
            if (max > value.length()) {
                max = value.length();
            }
            for (int i = 2; i < max; ++i) {
                sb.setCharAt(i, '*');
            }
            value = sb.toString();
        }
        return value;
    }

    public Map getFields() {
        return this.fields;
    }
}

