<?php

cron_master::setCron('multiMailSend','mailSendCron','send');

class mailSendCron{

	/*
	 * 未送信の予約送信を送信する
	 */
	function send(){
		global $MAILSEND_ADDRES;
		global $MAILSEND_NAMES;

		$MSdb = GMList::getDB(self::getType());
		$MStable = $MSdb->getTable();
		$MStable = $MSdb->searchTable($MStable,'reserve_flag','=',true);
		$MStable = $MSdb->searchTable($MStable,'reserve_time','<',time());
		$MStable = $MSdb->searchTable($MStable,'send_f','=',false);

		$MSrow = $MSdb->getRow($MStable);

		$status["success"] = array();
		$status["through"] = array();
		for($i = 0 ; $i < $MSrow ; $i++){
			$MSrec = $MSdb->getRecord($MStable,$i);

			$receive_id = mod_list::getMailReceiveList($MSdb->getData($MSrec,"receive_id"));
			$user_type = $MSdb->getData($MSrec,'user_type');
			$s_mail = $MSdb->getData($MSrec,'sender_mail');
			$s_name = $MSdb->getData($MSrec,'sender_name');
			$s_name = is_null($s_name) ? $MAILSEND_NAMES : $s_name;

			$main = $MSdb->getData($MSrec,'main');
			$sub  = $MSdb->getData($MSrec,'sub');
			$sub = mod_cms::convertSpecialChars($sub,$user_type);
			$main = mod_cms::convertSpecialChars($main,$user_type);

			$gm = SystemUtil::getGMforType($user_type);
			$db = $gm->getDB();
			$table = $db->getTable();
			$table = $db->searchTable( $table, 'id', 'in', $receive_id );
			$row = $db->getRow($table);

			for( $i=0; $i<$row; $i++ )
			{
				$rec = $db->getRecord( $table, $i );
				$_sub = $gm->getCCResult($rec,$sub);
				$_main = $gm->getCCResult($rec,$main);
				$mail = $db->getData( $rec, 'mail' );

				Mail::sendString( $_sub , $_main , $s_mail, $mail, $s_name);
				$status["success"][] = $db->getData($rec,"id");
			}
		}

		$MSdb->setTableDataUpdate( $MStable , 'send_time' , time() );
		$MSdb->setTableDataUpdate( $MStable , 'success_id' , implode("/", $status["success"]));
		$MSdb->setTableDataUpdate( $MStable , 'through_id', implode("/", $status["through"]));
		$MSdb->setTableDataUpdate( $MStable , 'send_f' , true );

	}

	function getType(){
		return "mailSend";
	}
}