<?php

	/*******************************************************************************************************
	 * <PRE>
	 * 
	 * ccProcクラス。
	 * 
	 * @author 丹羽一智
	 * @version 3.0.0
	 * 
	 * </PRE>
	 *******************************************************************************************************/
	class ccProc
	{
        private static $_DEBUG	 = DEBUG_FLAG_CCPROC;
		
		//debugフラグ操作用
        static function onDebug(){ self::$_DEBUG = true; }
        static function offDebug(){ self::$_DEBUG = false; }
		
		// 関数の割り振り
		static function controller(&$gm, $rec, $cc)
		{
			if( self::$_DEBUG ){ d($cc,'ccProc'); }
			
			switch($cc[0])
			{
			case 'readhead':
			case 'readend':
            case 'ifbegin':
            case 'elseif':
            case 'else':
            case 'endif':
            case 'switch':
            case 'case':
            case 'break':
            case 'endswitch':
            case 'default':
				return;
			case 'include':
				return ccProc::drawDesign($gm, $rec, $cc);
			case 'adapt':
				return ccProc::drawAdapt($gm, $rec, $cc);
            case '//':
                return;
			default:
				return ccProc::$cc[0]($gm, $rec, $cc);
			}
		}
		
		// テンプレートに関連付けられたレコードの引数で指定されたカラムの内容を出力する。
		function value(&$gm, $rec, $cc)
		{
			$ret = "";
			if( !isset($gm) ) { exit( 'CommandComment Null Pointer Error -> $gm ( via value )' ); }
			if( isset($_GET[$cc[1]]) ) { $_POST[$cc[1]] = $_GET[$cc[1]]; }
			
			$db = $gm->getDB();
			$type = $gm->colType[$cc[1]];

			if( $cc[1] == 'delete_time')
			{
				$type = 'timestamp';
			}

			switch($type)
			{
			case 'timestamp':
				$time	  = $db->getData( $rec, $cc[1] );
				if( $time > 0 ){
					if( isset($cc[2]) && strtolower($cc[2]) == 'false' )	{ $ret	.= $time; }
					else								{ $ret	.= SystemUtil::mb_date(  $gm->timeFormat, $time  ); }
				}
				break;
			case 'date':
				$date	  = $db->getData( $rec, $cc[1] );
				if( $date > 0 ){
					if( isset($cc[2]) && strtolower($cc[2]) == 'false' ){ $ret	.= $date; }
					else												{ $ret	.= SystemUtil::date( $gm->dateFormat, $date ); }
				}
				break;
			case 'boolean':
				if( $db->getData($rec, $cc[1]) ) { $ret .= 'TRUE'; }
				else							 { $ret .= 'FALSE'; }

				break;
			default:
				if( is_null($rec) && isset($_POST[$cc[1]]) )
				{ 
					$brFlg = false;
					if( isset($cc[2]) && strtoupper($cc[2]) == 'TRUE' ) { $brFlg = true; }
					
					if($brFlg)	 { $ret .= brChange($_POST[$cc[1]]); }
					else		 { $ret .= $_POST[$cc[1]]; }
				}
				else
				{
						$ret .= $db->getData( $rec, $cc[1], !(isset($cc[2]) && strtoupper($cc[2]) == 'FALSE') );
				}
				
				break;
			}
			
			//戻り値が空の場合のデフォルトをセット
			if( !strlen($ret) && isset($cc[3]) ){  $ret = $cc[3]; }
			
			return $ret;
		}

		// 設定されたレコードをカラム名で検索し、マッチした項目を複数の文字列から検索、対応する文字列を表示する。
		function valueReplace(&$gm, $rec, $cc)
		{
			$ret = "";
			if( !isset($gm) ) { exit( 'CommandComment Null Pointer Error -> $gm ( via valueReplace )' ); }
			$db   = $gm->getDB();
			$data = $db->getData( $rec, $cc[1] );
			if( is_bool($data) )
			{
				if( $data ) { $data	 = 'TRUE'; }
				else		{ $data	 = 'FALSE'; }
				$cc[2] = strtoupper($cc[2]);
			}
			$befor = explode( '/', $cc[2] );
			$after = explode( '/', $cc[3] );
			for($i=0; $i<count($befor); $i++)
			{
				if( $data == $befor[$i] ) { $ret .= $after[$i]; break; }
			}
			
			//戻り値が空の場合のデフォルトをセット
			if( !strlen($ret) && isset($cc[4]) ){  $ret = $cc[4]; }
			return $ret;
		}

		// 第一引数で入力した文字列を複数の文字列から検索、対応する文字列を表示する。
		function valueValueReplace(&$gm, $rec, $cc)
		{
			$ret = "";
			if( !isset($gm) ) { exit( 'CommandComment Null Pointer Error -> $gm ( via valueValueReplace )' ); }
			$data = $cc[1];
			if( is_bool($data) )
			{
				if( $data ) { $data	 = 'TRUE'; }
				else		{ $data	 = 'FALSE'; }
				$cc[2] = strtoupper($cc[2]);
			}
			$befor	 = explode( '/', $cc[2] );
			$after	 = explode( '/', $cc[3] );
			for($i=0; $i<count($befor); $i++)
			{
				if( $data == $befor[$i] ) { $ret .= $after[$i]; break; }
			}
			
			//戻り値が空の場合のデフォルトをセット
			if( !strlen($ret) && isset($cc[4]) ){  $ret = $cc[4]; }
			return $ret;
		}
        
        function arrayReplace(&$gm, $rec, $cc)
        {
			$ret = "";
			if( !isset($gm) ) { exit( 'CommandComment Null Pointer Error -> $gm ( via arrayReplace )' ); }
			$db = $gm->getDB();
            
			$array	 = explode( '/', $db->getData( $rec, $cc[1] ) );
			$befor	 = array_flip(explode( '/', $cc[3] ));
			$after	 = explode( '/', $cc[4] );
                
			foreach( $array as $data ){
                if( is_bool($data) )
                {
                    if( $data ) { $data	 = 'TRUE'; }
                    else		{ $data	 = 'FALSE'; }
                    $cc[3]	 = strtoupper($cc[3]);
                }
                
                if( strlen($ret) ) { $ret .= $cc[2]; }
                
                if( isset( $befor[$data] ) && isset($after[ $befor[$data] ]) ){
               		$ret .= $after[ $befor[$data] ];
				}
			}
			
			//戻り値が空の場合のデフォルトをセット
			if( !strlen($ret) && isset($cc[5]) ){  $ret = $cc[5]; }
			return $ret;
        }

        static $alias_cash = null;
		// テンプレートに関連づけられたレコードの指定されたカラムを別テーブルの指定カラムをキーに検索を行ない置換を行なう。 
		function alias(&$_gm, $rec, $cc)
		{
			$ret = "";
			if( !isset($_gm) ) { exit( 'CommandComment Null Pointer Error -> $gm ( via alias )' ); }
			
			$tables	= explode( '/', $cc[1] );
			$key	= $cc[2];
			$vals	= explode( '/', $cc[3] );
			$draws	= explode( '/', $cc[4] );
			
			$value		 = $_gm->db->getData( $rec, $key );
			
			$cnt = count($tables);
			for( $i=0 ; $i<$cnt && $value != '' ; $i++ )
			{
				if( !isset($_gm->aliasDB[$tables[$i]]) ) { $_gm->addAlias($tables[$i]); }
				$gm = GMList::getGM( $tables[$i] );
				$db = $gm->getDB();
				if( isset(self::$alias_cash[$tables[$i]]) && isset(self::$alias_cash[$tables[$i]][$vals[$i]]) && isset(self::$alias_cash[$tables[$i]][$vals[$i]][$value]) ){
					$rec = self::$alias_cash[$tables[$i]][$vals[$i]][$value];
				}else{
					$table = $db->getTable($_gm->table_type);
					$table		 = $db->searchTable(  $table, $vals[$i], '=', $value );
					$rec		= $db->getRecord( $table, 0 );
					self::$alias_cash[$tables[$i]][$vals[$i]][$value] = $rec;
				}
				
				//timestampやboolに対応する為
				//$value		= $db->getData( $rec, $draws[$i], true );
				$oldFormat = $gm->timeFormat;
				$gm->timeFormat = $_gm->timeFormat;
				$value = self::controller( $gm, $rec, array( "value", $draws[$i] ) );
				$gm->timeFormat = $oldFormat;
			}	
			
			$ret .= $value;
		
			//戻り値が空の場合のデフォルトをセット
			if( !strlen($ret) && isset($cc[5]) ){  $ret = $cc[5]; }
			return $ret;
		}

		// 指定した文字列を別テーブルの指定カラムをキーに検索を行ない置換を行なう。 
		function valueAlias(&$_gm, $_rec, $cc)
		{
			$ret = "";
			if( !isset($_gm) ) { exit( 'CommandComment Null Pointer Error -> $_gm ( via valueAlias )' ); }
			if( !isset($_gm->aliasDB[$cc[1]]) ) { $_gm->addAlias($cc[1]); }
			
			$gm = GMList::getGM( $cc[1] );
			$db = $_gm->aliasDB[$cc[1]];
			
			if( isset(self::$alias_cash[$cc[1]]) && isset(self::$alias_cash[$cc[1]][ $cc[3]]) && isset(self::$alias_cash[$cc[1]][ $cc[3]][$cc[2]]) ){
				$rec = self::$alias_cash[$cc[1]][ $cc[3]][$cc[2]];
			}else{
				$table = $db->getTable($_gm->table_type);
				$table = $db->searchTable( $table, $cc[3], '=', $cc[2] );
				$rec   = $db->getRecord( $table, 0 );
				self::$alias_cash[$cc[1]][ $cc[3]][$cc[2]] = $rec;
			}
			
				//timestampやboolに対応する為
			//$ret .= $db->getData( $rec, $cc[4], true );
			$oldFormat = $gm->timeFormat;
			$gm->timeFormat = $_gm->timeFormat;
			$ret .= self::controller( $gm, $rec, array( "value",  $cc[4] ) );
			$gm->timeFormat = $oldFormat;
			
			//戻り値が空の場合のデフォルトをセット
			if( !strlen($ret) && isset($cc[5]) ){  $ret = $cc[5]; }
			
			return $ret;
		}

		// 指定したカラムに入った各文字列を別テーブルの指定カラムをキーに検索を行ない置換を行ない、その一覧を返す。
		function arrayAlias(&$_gm, $_rec, $cc)
		{
			$ret = array();
			if( !isset($_gm) ) { exit( 'CommandComment Null Pointer Error -> $_gm ( via arrayAlias )' ); }
			if( !isset( $_gm->aliasDB[$cc[1]] ) ) { $_gm->addAlias($cc[1]); }
			
			$sep = '/';
			if( isset( $cc[5])){ $sep = $cc[5]; }
			
			$gm = GMList::getGM( $cc[1] );
			$db    = $_gm->aliasDB[$cc[1]];
			$table = $db->getTable($_gm->table_type);
					
			$data = $_gm->db->getData( $_rec, $cc[2] );

			if( !empty( $data ) ){
				$array       = explode( '/' , $data );
			foreach( $array as $key ){
				if( strlen($key) == 0 ) { continue; }
				if( isset(self::$alias_cash[$cc[1]]) && isset(self::$alias_cash[$cc[1]][$cc[3]]) && isset(self::$alias_cash[$cc[1]][$cc[3]][$key]) ){
					$arec = self::$alias_cash[$cc[1]][$cc[3]][$key];
				}else{
					$stable	 = $db->searchTable( $table, $cc[3], '=', $key );
					if( $db->getRow( $stable ) == 0 ) { continue; }
					$arec	 = $db->getRecord( $stable, 0 );
					self::$alias_cash[$cc[1]][$cc[3]][$key] = $arec;
				}

				$oldFormat = $gm->timeFormat;
				$gm->timeFormat = $_gm->timeFormat;
				$ret[] = self::controller( $gm, $arec, array( "value",  $cc[4] ) );
				$gm->timeFormat = $oldFormat;
			}
			
				return join( $ret, $sep );
			}else{
				//戻り値が空の場合のデフォルトをセット
				return $cc[6];
			}
		}

		// /で結合した置換後の文字列配列を返す。 
		function arrayValueAlias(&$_gm, $_rec, $cc)
		{
			$ret = array();
			if( !isset($_gm) ) { exit( 'CommandComment Null Pointer Error -> $_gm ( via arrayValueAlias )' ); }
			if( !isset( $_gm->aliasDB[$cc[1]] ) ) { $_gm->addAlias($cc[1]); }
			
			$gm = GMList::getGM( $cc[1] );
			$db    = $_gm->aliasDB[$cc[1]];
			$table = $db->getTable();
			
			if( !empty( $cc[2] ) ){

				$array = explode( '/' , $cc[2] );
				foreach( $array as $key ){
					if( isset(self::$alias_cash[$cc[1]]) && isset(self::$alias_cash[$cc[1]][$cc[3]]) && isset(self::$alias_cash[$cc[1]][$cc[3]][$key]) ){
						$arec = self::$alias_cash[$cc[1]][$cc[3]][$key];
					}else{
						$stable	 = $db->searchTable( $table, $cc[3], '=', $key );
						$arec	 = $db->getRecord( $stable, 0 );
						self::$alias_cash[$cc[1]][$cc[3]][$key] = $arec;
					}

					$oldFormat = $gm->timeFormat;
					$gm->timeFormat = $_gm->timeFormat;
					$ret[] = self::controller( $gm, $arec, array( "value",  $cc[4] ) );
					$gm->timeFormat = $oldFormat;
				}
			
				return join( $ret, $sep );
			}else{
				//戻り値が空の場合のデフォルトをセット
				return $cc[6];
			}
		}
		
		// テンプレートに関連づいたレコードから指定したカラムの値を抜きだし、存在する場合はそれを画像のパスとしてimgタグに受け渡し表示する。
		function object(&$gm, $rec, $cc)
		{
			global $IMAGE_NOT_FOUND;
			$ret = "";
			switch($cc[1])
			{
			case 'image':
					//size,alt,str,not,link等を柔軟に指定可能なimg出力
					$not = $IMAGE_NOT_FOUND;
					if( strlen($cc[2]) ){	$elements['src'] = $gm->db->getData( $rec, $cc[2] );	}
					$elements['alt'] = '';
					
					$link = false;
					$thumbnail = true;
					$ret = "";
					
					for($i=3;$i<count($cc);$i++){
						switch($cc[$i]){
							case 'size':
								$elements['width'] = $cc[++$i];
								$elements['height'] = $cc[++$i];
								break;
							case 'not':		$not = $cc[++$i]; break;
							case 'link':	$link = true; break;
							case 'nothumbnail': $thumbnail=false; break;
							case 'option': $option = $cc[++$i]; break;
							case 'img_suffix': $img_suffix = $cc[++$i]; break;
							case 'link_option': $link_option = $cc[++$i]; break;
							default://alt,srcなど
								$elements[$cc[$i]] = $cc[++$i];
								break;
						}
					}
					
					if( !isset($elements['src']) || !strlen($elements['src']) ){ return $not; }
					
					if($link){
						$ret	.= '<a href="'. $elements['src'] .'" ';
						if(isset($link_option)){ $ret .= $link_option; }
						else{ $ret .= 'target="_blank" ';}
						$ret	.= '>';
					}
			
					if( $thumbnail && isset($elements['width']) && isset($elements['height']) ){
						if( WS_SYSTEM_GDIMAGE_PROGRESS_IMAGE )
							{ $elements['src'] = 'thumb.php?src=' . $elements[ 'src' ] . '&width=' . $elements[ 'width' ] . '&height=' . $elements[ 'height' ]; }
						else
							{ $elements['src'] = mod_Thumbnail::Create( $elements['src'],$elements['width'],$elements['height']); }
					}
					
					$ret .= '<img ';
					foreach( $elements as $name => $val ){ $ret .= $name.'="'.$val.'" '; }
					if(isset($option)){ $ret .= $option.' '; }
					$ret .= '/>';
			
					if(isset($img_suffix)){ $ret .= $img_suffix; }
					
					if($link){	$ret    .= '</a>';	}
				break;
					
			case 'imageSize':
					// 画像が存在する場合はそれを画像のパスとしてimgタグに受け渡し表示する。widthとheightを設定可能。
					$param = Array( 'object','image',$cc[2],'size',$cc[3],$cc[4]);
					if(isset($cc[5])){ $param[] = 'option'; $param[] = $cc[5];}
					$ret .= self::object($gm, $rec, $param);
				break;
			case 'imageStr':
				// 表示する画像のパスを文字列指定で渡す。
					$param = Array( 'object','image','','src',$cc[2]);
					$ret .= self::object($gm, $rec, $param);
				break;
			case 'imageSizeStr':
				// 表示する画像のパスを文字列指定で渡す。widthとheightを設定可能。
					$param = Array( 'object','image','','src',$cc[2],'size',$cc[3],$cc[4]);
					if(isset($cc[5])){ $param[] = 'option'; $param[] = $cc[5];}
					$ret .= self::object($gm, $rec, $param);
				break;
			case 'linkImage':
					// 画像が存在する場合はそれを画像のパスとしてimgタグに受け渡し表示する。画像には画像へのリンクを付与する。 
					$param = Array( 'object','image',$cc[2],'link');
					if(isset($cc[3])){ $param[] = 'option'; $param[] = $cc[3];}
					$ret .= self::object($gm, $rec, $param);
				break;
			case 'linkImageSize':
					$param = Array( 'object','image',$cc[2],'size',$cc[3],$cc[4],'link');
					if(isset($cc[5])){ $param[] = 'option'; $param[] = $cc[5];}
					$ret .= self::object($gm, $rec, $param);
				break;
			case 'imageSizeNotfound':
					$param = Array( 'object','image',$cc[2],'size',$cc[3],$cc[4],'not',$cc[5]);
					if(isset($cc[6])){ $param[] = 'option'; $param[] = $cc[6];}
					$ret .= self::object($gm, $rec, $param);
				break;
			}
			return $ret;
		}
		
		// formを出力する。
		function form(&$gm, $rec, $cc)
		{
			$ret = "";
			$col = $cc[2];
			
			/*
				パラメータは POST,record,GET,デフォルト値の順で読み込まれる
			*/
			if( isset($_POST[$col]) ){
				$initial = $_POST[$col];
			}else if( !is_null($rec) && $gm->getDB()->isColumn($col) )
			{ 
				$db = $gm->getDB();
				$initial = $db->getData( $rec, $col );
			}else if( isset($_GET[$col]) )
			{
				$initial = $_GET[$col];
			}
	
			switch($cc[1])
			{
				case 'text':
					// textのinputタグを出力。
					$option = "";
					if( isset($cc[6]) ) { $option = $cc[6].' '; }
	
					if( isset($cc[3]) && strlen($cc[3]) ) { $option .= 'size="'. $cc[3] .'" '; }
					if( isset($cc[4]) && strlen($cc[4]) ) { $option .= 'maxlength="'. $cc[4] .'" '; }
	
					$value = "";
					if( isset($cc[5]) && strlen($cc[5]) ) {	$value = htmlspecialchars($cc[5]); }
					if( isset($initial) ) { $value = htmlspecialchars($initial); }
	
					$ret .= '<input type="text" name="'. $col .'" value="'.$value.'" '.$option .'/>'. "\n";
					break;
					
				case 'password':
						// passwordのinputタグを出力。
					$option = "";
					if( isset($cc[5]) ) { $option = $cc[5].' '; }
	
					if( isset($cc[3]) && strlen($cc[3]) ) { $option .= 'size="'. $cc[3] .'" '; }
					if( isset($cc[4]) && strlen($cc[4]) ) { $option .= 'maxlength="'. $cc[4] .'" '; }
	
					$ret .= '<input type="password" name="'. $col .'" '.$option .' />'. "\n";
					break;
					
				case 'textarea':
						// textareaタグを出力。
					$option	 = "";
					if( isset($cc[6]) ) { $option = $cc[6]; }
					
					$value = isset($cc[5])?$cc[5]:'';
					if( isset($initial) ) { $value = $initial; }
					if( isset($cc[ 7 ]) && 'nobr' != $cc[ 7 ] ){ $value = str_replace( '<br/>', "\n", $value ); }
	
					$ret .= '<textarea name="'. $col .'" cols="'. $cc[3] .'" rows="'. $cc[4] .'" '. $option .'>'. htmlspecialchars ( $value, ENT_QUOTES ) .'</textarea>'. "\n";
					break;
				
				case 'radiobox':
				case 'radio':
					// radioのinputタグを配列の数だけ出力
					$value	 = explode( '/', $cc[5] );
					$index	 = explode( '/', $cc[6] );
							
					$option	 = "";
					if( isset($cc[7]) ) { $option = $cc[7]; }
					
					$init = isset($cc[3])?$cc[3]:'';
					if( isset($initial) ) { $init = $initial; }
					
					$count = count($value);
					for($i=0; $i<$count; $i++)
					{
						$checked = "";
						if( $value[$i] == $init ) { $checked = ' checked="checked" '; }
						
						$ret .= '<label><input type="radio" name="'. $col .'" value="'. $value[$i] .'" '. $option .''.$checked.'/>'. $index[$i]. $cc[4]. "</label>\n"; 
					}
					break;
				case 'checkbox':
				case 'check':
					// checkboxのinputタグを配列の数だけ出力
					$value	 = explode( '/', $cc[5] );
					$index	 = explode( '/', $cc[6] );
							
					$option	 = "";
					if( isset($cc[7]) ) { $option = $cc[7]; }
					
					$init = array();
					if( isset($initial) )
					{
						if( is_array($initial) ) { $init = $initial; }
						else						 { $init = explode( '/', $initial ); }
					}else{ $init	 = explode( '/', $cc[3] ); }
					
					$valueCount	 = count($value);
					for($i=0; $i<$valueCount; $i++)
					{
						$checked = "";
						if( array_search($value[$i],$init) !== FALSE ){ $checked = ' checked="checked" '; }
	
						$ret .= '<label><input type="checkbox" name="'. $col .'[]" value="'. $value[$i] .'" '. $option .$checked.'/>'. $index[$i]. $cc[4]. "</label>\n";
					}
				
					if(!strlen($cc[8]) || $cc[8] != 'true' ) { $ret .= '<input type="hidden" name="'. $col .'_CHECKBOX" value="" />'."\n"; }
					break;
					
				case 'option':
					// プルダウン(select-optionタグのセット)を出力
					$value	 = explode( '/', $cc[4] );
					$index	 = explode( '/', $cc[5] );
						
					$option = "";
					if( isset($cc[6]) ) { $option	 = $cc[6]; }
					
					$init = $cc[3];
					if( isset($initial) ) { $init = $initial; }
					
					
					$ret .= '<select name="'. $col .'" '. $option .'>'. "\n";
					$count = count($value);
					for($i=0; $i<$count; $i++)
					{
						$selected = "";
						if( $value[$i] == $init ) { $selected = ' selected="selected" '; }
						
						$ret .= '<option value="'. $value[$i] .'"'.$selected.'>'. $index[$i] .'</option>'. "\n";
					}
					$ret .= '</select>'. "\n";
					
					break;
				case 'multiple':
					// プルダウン(select-optionタグのセット)を出力
					$value	 = explode( '/', $cc[4] );
					$index	 = explode( '/', $cc[5] );
					
					$option		 = "";
					if(  isset(  $cc[7]  )  )	{ $option	 = $cc[7]; }
					
					$init = $cc[3];
					if( isset($initial) ) {
						$init = $initial;
					}
					// array_searchのために配列化
					if ( !is_array($init) ) { $init = explode('/', $init); }
					
					$ret .= '<select name="'. $col .'[]" multiple="multiple" size="'.$cc[6].'" '. $option .'>'. "\n";
					$count = count($value);
					
					for($i=0; $i<$count; $i++)
					{
						$selected = '';
						if( array_search( $value[$i], $init ) !== FALSE ){ $selected = 'selected="selected"'; }
						
						$ret	 .= '<option value="'. $value[$i] .'" '.$selected.'>'. $index[$i] .'</option>'. "\n";
					}
					$ret	 .= '</select>'. "\n";
					
					break;
				case 'image':
					if( isset($initial) && strlen($initial) ){
						$param = Array( 'object','image',$col,'not','','link');
						if( isset($cc[5]) && strlen($cc[5]) ){
							$param[] = 'width';
							$param[] = $cc[5];
						}
						if( isset($cc[6]) && strlen($cc[6]) ){
							$param[] = 'height';
							$param[] = $cc[6];
						}
						$ret .= self::object($gm, $rec, $param);
						$ret .= '<br/>';
					}else if( ( !isset( $_POST[ $col.'_DELETE' ] ) || $_POST[ $col.'_DELETE' ] != 'true' ) && isset( $_POST[ $col.'_filetmp' ] ) ){
						$param = Array( 'object','image','','not','','link','src',$_POST[ $col.'_filetmp' ]);
						if( isset($cc[5]) && isset($cc[6]) ){
							$param[] = 'size';
							$param[] = $cc[5];
							$param[] = $cc[6];
						}
						$ret .= self::object($gm, $rec, $param);
						$ret .= '<br/>';
					}
				case 'file':
						// ファイル入力(type=fileのinputタグ)を出力
					$option	= "";
					if( isset($cc[3]) ){ $option = $cc[3]; }
					$ret .= '<input name="'. $col .'" type="file" '. $option .'/>'. "\n";
					
					if( isset($initial ) && strlen($initial) ){
						$ret	 .= '<input name="'. $col .'_filetmp" type="hidden" value="'.$initial.'" />'. "\n";
						if( !isset($cc[4]) || !strlen($cc[4]) ){ $cc[4] = '削除'; }
						$ret .= '<label><input type="checkbox" name="'.$col.'_DELETE" value="true" />'.$cc[4].'</label>';
					}else if( ( !isset( $_POST[ $col.'_DELETE' ] ) || $_POST[ $col.'_DELETE' ] != 'true' ) && isset( $_POST[ $col.'_filetmp' ] ) ){
						if( !isset($cc[4]) || !strlen($cc[4]) ){ $cc[4] = '削除'; }
						$ret .= '<label><input type="checkbox" name="'.$col.'_DELETE" value="true" checked="checked" />'.$cc[4].'</label>';
					}
					break;
					
				case 'hidden':
						// 不可視入力(type=hiddenのinputタグ)を出力
					$option	= "";
					if( isset($cc[4]) ) { $option = $cc[4]; }
					if( isset($cc[5]) ) { $num = $cc[5]; }else{$num="";}
					
					if( isset($initial ) ){
						if( is_array($initial) ){
							foreach( $initial as $val ){
								$ret .= '<input name="'. $col .'['.$num.']" type="hidden" value="'. htmlspecialchars($val) .'" '. $option .'/>'. "\n";
							}
						}
						else{
							$ret .= '<input name="'. $col .'" type="hidden" value="'. htmlspecialchars($initial) .'" '. $option .' />'. "\n";
						}
					}
					else {
						$value = '';
						if( isset($cc[3]) ){ $value = htmlspecialchars($cc[3]); }
						$ret .= '<input name="'. $col .'" type="hidden" value="'. $value .'" '. $option .'/>'. "\n";
					}
					break;
				case 'date':
					$option = "";
					if( isset($cc[4]) ) { $option = $cc[4]; }else{ $option="";}
					$y_key = $col.'_year';
					$m_key = $col.'_month';
					$d_key = $col.'_day';
					
					if( isset($cc[3]) && strlen($cc[3]) ){
						list($init_y, $init_m, $init_d) = explode( '-',$cc[3]);
					}else if( isset($initial ) && strlen($initial) ){
						$init_y = (int)substr($initial,0,4);
						$init_m = (int)substr($initial,5,2);
						$init_d = (int)substr($initial,8);
					}else{
						$init_y = $init_m = $init_d = "";
					}
					
					$ret = ccProc::controller($gm, $rec, array('form','text',$y_key,'4','4',$init_y,$option) ).$gm->dateFormat['y'];
					$ret .= ccProc::controller($gm, $rec, array('code','num_option',$m_key,'12',$init_m,'1','未選択',$option ) ).$gm->dateFormat['m'];
					$ret .= ccProc::controller($gm, $rec, array('code','num_option',$d_key,'31',$init_d,'1','未選択',$option ) ).$gm->dateFormat['d'];
					break;
				//ここからhtml5でサポートされたコマンド
				case 'tel':
					// telのinputタグを出力。
					$option = "";
					if( isset($cc[6]) ) { $option = $cc[6]; }
	
					if( isset($cc[3]) && strlen($cc[3]) ) { $option .= 'size="'. $cc[3] .'" '; }
					if( isset($cc[4]) && strlen($cc[4]) ) { $option .= 'maxlength="'. $cc[4] .'" '; }
	
					$value = "";
					if( isset($cc[5]) && strlen($cc[5]) ) {	$value = htmlspecialchars($cc[5]); }
					if( isset($initial) ) { $value = htmlspecialchars($initial); }
	
					$ret .= '<input type="tel" name="'. $col .'" value="'.$value.'" '.$option .'/>'. "\n";
					//placeholder
					break;
				case 'url':
					// urlのinputタグを出力。
					$option = "";
					if( isset($cc[6]) ) { $option = $cc[6]; }
	
					if( isset($cc[3]) && strlen($cc[3]) ) { $option .= 'size="'. $cc[3] .'" '; }
					if( isset($cc[4]) && strlen($cc[4]) ) { $option .= 'maxlength="'. $cc[4] .'" '; }
	
					$value = "";
					if( isset($cc[5]) && strlen($cc[5]) ) {	$value = htmlspecialchars($cc[5]); }
					if( isset($initial) ) { $value = htmlspecialchars($initial); }
	
					$ret .= '<input type="url" name="'. $col .'" value="'.$value.'" '.$option .' autocapitalize="off"/>'. "\n";
					//placeholder
					break;
				case 'number':
					// numberのinputタグを出力。
					$option = "";
					if( isset($cc[6]) ) { $option = $cc[6]; }
	
					//max min
					if( isset($cc[3]) && strlen($cc[3]) ) { $option .= 'max="'. $cc[3] .'" '; }
					if( isset($cc[4]) && strlen($cc[4]) ) { $option .= 'min="'. $cc[4] .'" '; }
	
					$value = "";
					if( isset($cc[5]) && strlen($cc[5]) ) {	$value = htmlspecialchars($cc[5]); }
					if( isset($initial) ) { $value = htmlspecialchars($initial); }
	
					$ret .= '<input type="number" name="'. $col .'" value="'.$value.'" '.$option .'/>'. "\n";
					break;
				case 'email':
					// emailのinputタグを出力。
					$option = "";
					if( isset($cc[6]) ) { $option = $cc[6]; }
	
					if( isset($cc[3]) && strlen($cc[3]) ) { $option .= 'size="'. $cc[3] .'" '; }
					if( isset($cc[4]) && strlen($cc[4]) ) { $option .= 'maxlength="'. $cc[4] .'" '; }
	
					$value = "";
					if( isset($cc[5]) && strlen($cc[5]) ) {	$value = htmlspecialchars($cc[5]); }
					if( isset($initial) ) { $value = htmlspecialchars($initial); }
	
					$ret .= '<input type="email" name="'. $col .'" value="'.$value.'" '.$option .' autocapitalize="off" />'. "\n";
					
					//multiple,placeholder
					break;
			}
		
			return $ret;
		}
		
		// テンプレートの表示に使用されるGUIManagerのインスタンスに設定した値を出力出来る。 
		function variable(&$gm, $rec, $cc)
		{
			$ret = "";
			if(  is_null( $gm->variable[$cc[1]] )  ) { exit( 'CommandComment Null Pointer Error -> variable : '. $cc[1] ); }
			$ret .= $gm->variable[$cc[1]];
			
			return $ret;
		}
		// テンプレートの表示に使用されるGUIManagerのインスタンスに設定した値を出力出来る。 
		// 未設定でもエラー出力がされない。
		function safeVariable(&$gm, $rec, $cc)
		{
			$ret = "";
			if( isset($gm->variable[ $cc[1] ]) && ! is_null( $gm->variable[ $cc[1] ] )  )	{ $ret	 .= $gm->variable[ $cc[1] ]; }
			
			return $ret;
		}

		
		// テンプレートを表示しようとしているページへのリクエストで渡されたGETパラメータを表示出来る。
		function get(&$gm, $rec, $cc)
		{
			array_shift( $cc );
			List( $name , $index ) = $cc;

			$ret = "";

				if( is_array( $_GET[ $name ] ) ) //POSTが配列の場合
				{
					if( !isset( $index ) )
					{ //indexが指定されていない場合
						$ret .= implode( '/' , $_GET[ $name ] );
					}
					else
					{ //indexが指定されている場合
						$ret .= $_GET[ $name ][ $index ];
				}
				}
				else
				{ //POSTがスカラの場合
					$ret .= $_GET[ $name ];
				}

			return $ret;
		}

		
		// テンプレートを表示しようとしているページへのリクエストで渡されたPOSTパラメータを表示出来る。
		function post( &$gm , $rec , $cc )
		{
			array_shift( $cc );
			List( $name , $index ) = $cc;

			$ret = "";

			if( is_array( $_POST[ $name ] ) ) //POSTが配列の場合
			{
				if( !isset( $index ) )
				{ //indexが指定されていない場合
					$ret .= implode( '/' , $_POST[ $name ] );
				}
				else
				{ //indexが指定されている場合
					$ret .= $_POST[ $name ][ $index ];
			}
			}
			else
			{ //POSTがスカラの場合
				$ret .= $_POST[ $name ];
			}

			return $ret;
		}
/*
		// $_SESSIONの値を出力
		function session(&$gm, $rec, $cc)
		{
			if( is_array( $_SESSION[$cc[1]] ) )
			{
				if( !isset($cc[2]) ) { exit( 'CommandComment Null Pointer Error -> session array index' ); }
				$ret .= $_SESSION[$cc[1]][$cc[2]];
			}
			else	{ $ret .= $_SESSION[$cc[1]]; }

			return $ret;
		}
*/

		// $_REQUESTの値を出力
		function request(&$gm, $rec, $cc)
		{
			if( is_array( $_REQUEST[$cc[1]] ) )
			{
				if( !isset($cc[2]) ) { exit( 'CommandComment Null Pointer Error -> request array index' ); }
				$ret .= $_REQUEST[$cc[1]][$cc[2]];
			}
			else	{ $ret .= $_REQUEST[$cc[1]]; }
			
			return $ret;
		}
		
		// valueでtimestampを表示する場合に使用するformatを指定出来る。
		function setTimeFormat(&$gm, $rec, $cc)
		{
			$ret = "";
			$gm->setTimeFormat(  str_replace(  Array( "!CODE000;","!CODE001;"), Array("/"," ") , $cc[1]) );
			
			return $ret;
		}

		// ユーザー情報を出力
		function login(&$gm, $rec, $cc)
		{
			global $NOT_LOGIN_USER_TYPE;
			global $loginUserType;
			global $loginUserRec;
			
			$ret = "";
			switch($cc[1])
			{
			case 'type':
				$ret = $loginUserType;
				break;
			default:
				if( $loginUserType != $NOT_LOGIN_USER_TYPE )
				{
					$tgm = GMList::getGM($loginUserType);
					$ret = ccProc::value( $tgm, $loginUserRec, $cc );
				}
				break; 
			}

			return $ret;
		}

		// Command.phpで定義されているコメントコマンドを呼び出す事が出来る。
		function code(&$gm, $rec, $cc)
		{
			$ret  = "";
			$args = array_slice($cc,2);
			$e = new Command();
			$e->$cc[1]( $gm, $rec, $args );
			$ret .= $e->getBuffer();
			
			return $ret;
		}

		// Extension.phpで定義されているコメントコマンドを呼び出す事が出来る。
		function ecode(&$gm, $rec, $cc)
		{
			$ret  = "";
			$args = array_slice($cc,2);
			$e = new Extension();
			$e->$cc[1]( $gm, $rec, $args );
			$ret .= $e->getBuffer();
			
			return $ret;
		}

		
		// System.php内のSystemクラスで定義されているコメントコマンドを呼び出す事が出来る。
		function syscode(&$gm, $rec, $cc)
		{
			$ret  = "";
			$args = array_slice($cc,2);

			$sys  = SystemUtil::getSystem( isset($_GET["type"])?$_GET["type"]:null );
			
			$sys->$cc[1]( $gm, $rec, $args );
			$ret .= $sys->getBuffer();
			
			return $ret;
		}

		// ./module/以下に設置され./module/module.phpによりincludeされたモジュールファイル内で定義されたモジュールクラス内のメソッドを呼び出す事が可能。
		function mod(&$gm, $rec, $cc)
		{
			$ret  = "";
			$args = array_slice($cc,3);
			
			$class_name = 'mod_'.$cc[1];
			if( !class_exists( $class_name ) ){
				return $ret;
			}

			$sys = new $class_name();
			
			$sys->$cc[2]( $gm, $rec, $args );
			$ret .= $sys->getBuffer();

			return $ret;
		}
		
		// ./custom/view以下に設置されてincludeされたモジュールファイル内で定義されたモジュールクラス内のメソッドを呼び出す事が可能。
		function view(&$gm, $rec, $cc)
		{
			global $view_path;
			
			$ret  = "";
			$args = array_slice($cc,3);
			
			$class_name = $cc[1].'View';
			
			if( !class_exists( $class_name ) ){
				if( file_exists( $view_path.$class_name.'.php') )
				{
					include_once $view_path.$class_name.'.php';
					if ( !class_exists( $class_name ) ) {
	                	global $ALL_DEBUG_FLAG;
	                	if( $ALL_DEBUG_FLAG ){ d( '['.$cc[1].'View] not found.' ,'view');}
						return $ret;
					}
				}else{
                	global $ALL_DEBUG_FLAG;
                	if( $ALL_DEBUG_FLAG ){ d( '['.$cc[1].'View] not found.' ,'view');}
					return $ret;
				}
			}	

			$sys = new $class_name();
			
			$sys->$cc[2]( $gm, $rec, $args );
			$ret .= $sys->getBuffer();

			return $ret;
		}
		
		// 引数に与えられた文字を計算式として解釈し、計算結果を返す。
		function calc(&$gm, $rec, $cc)
		{
			$ret  = "";
			$calc = join('',array_slice($cc,1));
			if( ! SystemUtil::is_expression($calc ) ){
				return $ret;
			}
			eval( '$ret = '.$calc.';' );
			
			return $ret;
		}

		// このコマンドは他のコマンドの前に付ける形で利用する事により、戻り値に含まれる半角スペースをエスケープした結果を返す。
		function escp(&$gm, $rec, $cc)
		{
			$ret = "";
			$cc  = array_slice($cc,1);
			$ret = str_replace( Array( '!CODE001;', ' ') , '!CODE101;', ccProc::controller($gm, $rec, $cc) );
			///$ret = str_replace( '!CODE001;' , '!CODE101;', ccProc::controller($gm, $rec, $cc) );
			return $ret;
		}

		function ent(&$gm, $rec, $cc)
		{
			$ret = "";
			$cc  = array_slice($cc,1);
			$ret = htmlspecialchars( ccProc::controller($gm, $rec, $cc) );
			return $ret;
		}

		// このコマンドは他のコマンドの前に付ける形で利用する事により、戻り値をint型にcastして返す。
		function int(&$gm, $rec, $cc)
		{
			$ret = "";
			$cc  = array_slice($cc,1);
			$ret = (int)ccProc::controller($gm, $rec, $cc);
			
			return $ret;
		}
		// このコマンドは他のコマンドの前に付ける形で利用する事により、戻り値をint型にcastして返す。
		function bool(&$gm, $rec, $cc)
		{
			$ret			 = "";
			$cc = array_slice($cc,1);
			$ret = SystemUtil::convertBool(ccProc::controller($gm, $rec, $cc)) ? 'TRUE':'FALSE';
			
			return $ret;
		}
		// このコマンドは他のコマンドの前に付ける形で利用する事により、戻り値をurlencodeして返す。
		function urlenc(&$gm, $rec, $cc)
		{
			$ret			 = "";
			$cc = array_slice($cc,1);
			$ret = urlencode(ccProc::controller($gm, $rec, $cc));
			
			return $ret;
		}

		// このコマンドは他のコマンドの前に付ける形で利用する事により、戻り値の第1引数に指定された文字を第2引数に指定された文字に置換して返す。
		function rep(&$gm, $rec, $cc)
		{
			$ret			 = "";
			$search = $cc[1];
			$replace = $cc[2];
			$cc = array_slice($cc,3);
			$ret = str_replace( $search, $replace, ccProc::controller($gm, $rec, $cc));
			
			return $ret;
		}
	
		/**
		 * substituteコマンド。
		 * このコマンドは他のコマンドの前に付ける形で利用する事により、戻り値が空の場合に第一引数の値を出力する。
		 * 
		 */
		function sub(&$gm, $rec, $cc)
		{
			
			$ret			 = "";
			$cc2 = array_slice($cc,2);
			$ret = ccProc::controller($gm, $rec, $cc2);
			
			if( !strlen($ret) ){
				$ret = $cc[1];
			}
			
			return $ret;
		}
		
		// $cc の内容を連結して出力
		function join(&$gm, $rec, $cc)
		{
			$ret = "";
			$cc  = array_slice($cc,1);
			$ret = join( '' , $cc );
			
			return $ret;
		}

		// 引数に与えられた文字を変数として解釈し、中身を返す。
		function val(&$gm, $rec, $cc)
		{
			$ret = "";
			
			if( ! preg_match( '/^[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*$/', $cc[1] ) ){
				return $ret;
			}
			
			eval( 'global $'.$cc[1].'; $ret = $'.$cc[1].';' );
			
            if(is_bool($ret)){
    			if( $ret )	 { $ret	 = 'TRUE'; }
	    		else		 { $ret	 = 'FALSE'; }
            }
            
			return $ret;
		}
			
		// このコマンドは他のtemplateをtemplate内に展開する事が出来る。
		// ただし、templateテーブルに「INCLUDE_DESIGN」ラベルを設定されたものに限る。
		function drawDesign(&$gm, $rec, $cc)
		{
			global $loginUserType;
			global $NOT_LOGIN_USER_TYPE;
			global $loginUserRank;
			
            $file = Template::getTemplate( $loginUserType , $loginUserRank , $cc[1] , 'INCLUDE_DESIGN' );

            $partkey = null;
            if( isset( $cc[2] ) ){ $partkey = $cc[2]; }
            
            if( ! strlen($file) ){
                $ret = "<br/><br/><br/>!include error! -> ".$cc[1]."<br/><br/><br/>";
            }else if( is_null($gm) ){
            	if( $loginUserType == $NOT_LOGIN_USER_TYPE ){
            		$ret = SystemUtil::getGMforType('system')->getString( $file , $rec , $partkey );
            	}else{
            		$ret = SystemUtil::getGMforType($loginUserType)->getString( $file , $rec , $partkey );
            	}
                
            }else{
                $ret = $gm->getString( $file , $rec , $partkey );
            }

			return $ret;
		}

		function drawAdapt(&$gm, $rec, $cc)
		{
			global $loginUserType;
			global $NOT_LOGIN_USER_TYPE;
			global $loginUserRank;
			
            $file = $gm->getCurrentTemplate();

            $partkey = null;
            if( isset( $cc[1] ) ){ $partkey = $cc[1]; }
            
            if( ! strlen($file) ){
                $ret = "<br/><br/><br/>!adapt error! -> ".$cc[1]."<br/><br/><br/>";
            }else if( ! strlen($file) ){
                $ret = "<br/><br/><br/>!adapt part error! -> ".$cc[1]."<br/><br/><br/>";
            }else if( is_null($gm) ){
            	if( $loginUserType == $NOT_LOGIN_USER_TYPE ){
            		$ret = SystemUtil::getGMforType('system')->getString( $file , $rec , $partkey );
            	}else{
            		$ret = SystemUtil::getGMforType($loginUserType)->getString( $file , $rec , $partkey );
            	}
                
            }else{
                $ret = $gm->getString( $file , $rec , $partkey );
            }

			return $ret;
		}
		
		//内部変換テーブルに従って絵文字を出力する
		function emoji(&$gm, $rec, $cc){
			global $EMOJI_CHARSET_MAP;
			global $terminal_type;
			
			if( !is_array($EMOJI_CHARSET_MAP) || !is_numeric($cc[1])){ return ""; }
			
			eval( '$ret = '. $EMOJI_CHARSET_MAP[ $cc[1] ].";" );
			return $ret;
		}
        
		/**
			@brief     次に呼び出されるコマンドコメントのために、挿入パラメータを設定する。
			@exception InvalidCCArgumentException 不正なパラメータを指定した場合。
			@details   パラメータは次の順で指定します。
				@li 0 挿入パラメータの名前。
				@li 1 挿入パラメータの値。
				@li 2 挿入パラメータを使用するコマンドコメント名。省略した場合は全てのコマンドコメントが参照可能です。
				@li 3 挿入パラメータの寿命。once/allのいずれかを指定します。onceパラメータは一度でも参照されると初期化されます。省略した場合はonceとなります。
			@param[in] $iGM_  GUIManagerオブジェクト。
			@param[in] $iRec_ レコードデータ。
			@param[in] $iCC_  コマンドコメントパラメータ。
			@attension コマンドコメントは個別にweaveに対応する必要があります。\n
			           挿入パラメータの取得にはWeaveクラスを使用してください。
		*/
		function weave( &$iGM_ , $iRec_ , $iCC_ )
		{
			List( $ccName , $paramName , $paramValue , $targetName , $paramLife ) = $iCC_;

			if( !$paramName ) //挿入パラメータ名が指定されていない場合
				{ throw new InvalidCCArgumentException( '引数 $paramName は無効です' ); }

			if( !$targetName ) //対象コマンドコメント名が設定されていない場合
				{ $targetName = '*'; }

			if( $paramLife ) //挿入パラメータの寿命が設定されている場合
			{
				switch( $paramLife ) //設定値で分岐
				{
					case 'once' : //一度きり
					case 'all'  : //永久
						{ break; }

					default : //値の候補に一致しない場合
						{ throw new InvalidCCArgumentException( '引数 $paramLife は無効です[' . $paramLife . ']' ); }
				}
			}
			else //挿入パラメータの寿命が設定されていない場合
				{ $paramLife = 'once'; }

			Weave::Push( $paramName , $paramValue , $targetName , $paramLife );
		}

		/**
			@brief     挿入パラメータを削除する。
			@exception InvalidCCArgumentException 不正なパラメータを指定した場合。
			@details   パラメータは次の順で指定します。
				@li 0 削除する挿入パラメータ名。
				@li 1 挿入パラメータを使用するコマンドコメント名。省略した場合は全てのコマンドに対するパラメータを削除します。
			@param[in] $iGM_  GUIManagerオブジェクト。
			@param[in] $iRec_ レコードデータ。
			@param[in] $iCC_  コマンドコメントパラメータ。
		*/
		function clearWeave( &$iGM_ , $iRec_ , $iCC_ )
		{
			List( $ccName , $paramName , $targetName ) = $iCC_;

			if( !$paramName ) //挿入パラメータ名が指定されていない場合
				{ throw new InvalidCCArgumentException( '引数 $paramName は無効です' ); }

			Weave::Pop( $paramName , $targetName );
		}



    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////    
    //出力ではなくシステム側に作用する特殊なコメントコマンド
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
        //templateの条件付きパーサー
        //C言語の条件付きコンパイル(#ifdef)みたいなもの
        //@return boolean(true/false)
        function ifbegin(&$gm, $rec, $cc)
		{
            switch( $cc[1] ){
                case 'not':
                case '!':
                    //条件の反転
                    return ! ccProc::ifbegin($gm, $rec, array_slice($cc,1));
                case 'alias':
                	$alias_gm = SystemUtil::getGMforType( $cc[2] );
                	$db = $alias_gm->getDB();
                	$alias_rec = $db->selectRecord( $cc[3] );
                	
                    return ccProc::ifbegin($alias_gm, $alias_rec, array_slice($cc,3));
                case 'bool':
                case 'boolean':
                    $db = $gm->getDB();
                    return SystemUtil::convertBool($db->getData( $rec , $cc[2] ));
                case 'intime'://指定カラムが指定期間内かどうか
                    $db = $gm->getDB();
                    $time = $db->getData( $rec , $cc[2] );
                    $period = time() - $cc[3]*3600;
                    return $time > $period;
                case 'val_intime'://指定カラムが指定期間内かどうか
                    $period = time() - $cc[3]*3600;
                    return $cc[2] > $period;
                case 'isget':
                    //getにその引数が存在するかどうか。
                    return isset($_GET[$cc[2]]) && strlen($_GET[$cc[2]]);
                case 'ispost':
                    //postにその引数が存在するかどうか。
                    return isset($_POST[$cc[2]]) && strlen($_POST[$cc[2]]);
                case 'issession':
                    //sessionにその引数が存在するかどうか。
                    return isset($_SESSION[$cc[2]]) && strlen($_SESSION[$cc[2]]);
                case 'session':
                    //sessionにその引数が存在するかどうか。存在した場合はboolで
                    return isset($_SESSION[$cc[2]]) ? SystemUtil::convertBool($_SESSION[$cc[2]]) : false;
                case 'nullcheck':
                    $db = $gm->getDB();
                    //第二引数に指定されたカラムが設定されているかどうか
                    $cols = split( '/', $cc[2]);
                    foreach( $cols as $col ){
                        if( !strlen( $db->getData( $rec, $col) ) ){
                            return false;
                        }
                    }
                    return true;
                    break;
                case 'anycheck':
                    $db = $gm->getCachedDB();
                    //第二引数に指定されたカラムが設定されているかどうか
                    $cols = split( '/', $cc[2]);
                    foreach( $cols as $col ){
                        if( strlen( $db->getData( $rec, $col) ) ){
                            return true;
                        }
                    }
                    return false;
                    break;
                case 'zerocheck'://int型版のnullcheck
                    $db = $gm->getDB();
                    //第二引数に指定されたカラムが設定されているかどうか
                    $cols = split( '/', $cc[2]);
                    foreach( $cols as $col ){
                        if(  $db->getData( $rec, $col) == 0 ){
                            return false;
                        }
                    }
                    return true;
                    break;
                case 'eq':
                case 'equal':
                case '=':
                    //第二引数のカラム名としたレコードの値と、第三引数に指定された値が一致するかどうか。
                    $db = $gm->getDB();
                    return ($db->getData( $rec , $cc[2] ) == $cc[3]);
                case '>':
                    $db = $gm->getDB();
                    return ($db->getData( $rec , $cc[2] ) > $cc[3]);
                    break;
                case '<':
                    $db = $gm->getDB();
                    return ($db->getData( $rec , $cc[2] ) < $cc[3]);
                    break;
                case 'val_equal':
                case 'val_eq':
                case 'val=':
                    //第二、第三引数に指定された値が一致するかどうか。
                    $check = isset($cc[3])?$cc[3]:'';
                    return ($cc[2] == $check);
                case 'in':
                    //第二引数のカラム名としたレコードの値が、"/"で分割された第三引数の文字群に含まれているかどうか。
                    $db = $gm->getDB();
                    $val = $db->getData( $rec , $cc[2] );
                    $array = explode( '/', $cc[3] );
                    foreach( $array as $data ){
                    	if(($val == $data) ){return true;}
                    }
                    return false;
                case 'val_in':
                    //第二引数の値が、"/"で分割された第三引数の文字群に含まれているかどうか。
                    $val = $cc[2];
                    $array = explode( '/', $cc[3] );
                    foreach( $array as $data ){
                    	if(($val == $data) ){return true;}
                    }
                    return false;
                case 'array_in':
                    //第二引数のカラム名としたレコードの値を"/"で分割し、"/"で分割された第三引数の文字群に含まれているかどうか。
                    $db = $gm->getDB();
                    $vals = explode('/', $db->getData( $rec , $cc[2] ));
                    $array = explode( '/', $cc[3] );
					foreach( $vals as $val )
					{
						foreach( $array as $data ){
							if(($val == $data) ){return true;}
						}
					}
                    return false;
                case 'val_array_in':
                    //第二引数の値を"/"で分割し、"/"で分割された第三引数の文字群に含まれているかどうか。
                    $vals = explode('/', $cc[2]);
                    $array = explode( '/', $cc[3] );
                    foreach( $vals as $val )
					{
						foreach( $array as $data ){
							if(($val == $data) ){return true;}
						}
                    }
                    return false;
                case 'get_equal':
                case 'get=':
                    //第二引数をGET引数の連想配列名とした値と、第三引数に指定された値が一致するかどうか。
                    return isset($_GET[$cc[2]])?($_GET[$cc[2]]==$cc[3]):''==$cc[3];
                case 'post_equal':
                    //第二引数をGET引数の連想配列名とした値と、第三引数に指定された値が一致するかどうか。
                    return isset($_POST[$cc[2]])?($_POST[$cc[2]] == $cc[3]):''==$cc[3];
                case 'uri_match':
                	return (preg_match('/'.str_replace( array("!CODE001;","!CODE000;","!CODE002;"), array(" ", "/", "\\") , $cc[2] ).'$/',$_SERVER['REQUEST_URI']) > 0);
                	break;
                case 'uri_match_like':
                	return (preg_match('/'.str_replace( array("!CODE001;","!CODE000;","!CODE002;"), array(" ", "/", "\\") , $cc[2] ).'/',$_SERVER['REQUEST_URI']) > 0);
                	break;
                case 'val>':
                    return ($cc[2] > $cc[3]);
                    break;
                case 'val<':
                    return ($cc[2] < $cc[3]);
                    break;
                case 'val>=':
                    return ($cc[2] >= $cc[3]);
                    break;
                case 'val<=':
                    return ($cc[2] <= $cc[3]);
                    break;
                case 'mod_on':
                	return class_exists('mod_'.$cc[2]);
                case 'mod_off':
                	return !class_exists('mod_'.$cc[2]);
                case 'match':
                	return mb_ereg( $cc[3], $cc[2] ) !== FALSE;
                case 'login':
                	global $loginUserType;
                	return $loginUserType == $cc[2];
                case 'isvariable':
                	//GMのvariableにその値が存在するかどうか
                    return isset($gm->variable[$cc[2]]);
                case 'global':
                	global ${$cc[2]};
                	return ${$cc[2]};
				case 'is_all':	//rec,Post,getのどこかにデータがあるかどうか
					$ret = (!empty($_GET[$cc[2]])) || (!empty($_POST[$cc[2]]));
					if( $ret ) { return $ret; }
					$db = $gm->getDB();
					$val = $db->getData( $rec , $cc[2] );
					return !empty($val);
					break;
                case 'system':
                	$db = GMList::getDB( 'system' );
                	
                	$data = SystemUtil::getSystemData( $cc[2] );
                	
                	switch( $db->colType[$cc[2]] )
                	{
                		case 'boolean':
                			//booleanならそのまま使う
                			return $data;
                		default:
                			//文字列の場合は引数との比較
                			return $data == $cc[3];
                	}
                	return false;
                case 'true':
                	return true;
                case 'false':
                	return false;
                default:
                	global $ALL_DEBUG_FLAG;
                	if( $ALL_DEBUG_FLAG ){ d( '['.$cc[1].'] not found.' ,'ifbegin');}
            }
            return false;
        }
	}
?>